@extends('layouts.home')

@section('content')
    <section id="slider">
        <div class="uk-position-relative uk-visible-toggle uk-light" tabindex="-1"
             uk-slider="center: true ; autoplay: true">

            <ul class="uk-slider-items uk-grid">
                <li class="uk-width-1-1">
                    <div class="uk-panel">
                        <img src="{{ asset('front/img/slider.jpg') }}" alt="">
                    </div>
                </li>
                <li class="uk-width-1-1">
                    <div class="uk-panel">
                        <img src="{{ asset('front/img/slider1.jpg') }}" alt="">
                    </div>
                </li>
                <li class="uk-width-1-1">
                    <div class="uk-panel">
                        <img src="{{ asset('front/img/slider2.jpg') }}" alt="">
                    </div>
                </li>
            </ul>

            <a class="uk-position-center-left uk-position-small uk-hidden-hover" href="#" uk-slidenav-next
               uk-slider-item="next"> <img src="{{ asset('front/img/left.svg') }}" alt=""></a>
            <a class="uk-position-center-right uk-position-small uk-hidden-hover" href="#" uk-slidenav-previous
               uk-slider-item="previous"> <img src="{{ asset('front/img/right.svg') }}" alt=""></a>

        </div>
    </section>

    <section id="courses">
        <div class="uk-container">
            <div uk-filter="target: .js-filter">
                <div class="uk-grid" uk-grid>
                    {{--                    <div class="uk-width-1-2@m uk-width-1-1">--}}
                    {{--                        <ul class="uk-subnav uk-subnav-pill">--}}
                    {{--                            <li uk-filter-control=".tag1"><a href="#" class="tags-label">هنر</a></li>--}}
                    {{--                            <li uk-filter-control=".tag2"><a href="#" class="tags-label">زبان</a></li>--}}
                    {{--                            <li uk-filter-control=".tag3"><a href="#" class="tags-label">موسیقی</a></li>--}}
                    {{--                            <li uk-filter-control=".tag4"><a href="#" class="tags-label">کامپیوتر</a></li>--}}
                    {{--                            <li uk-filter-control=".tag5"><a href="#" class="tags-label">پزشکی</a></li>--}}
                    {{--                        </ul>--}}
                    {{--                    </div>--}}
                    <div class="uk-width-1-1@m uk-width-1-1 uk-text-left">
                        <div class="uk-margin uk-position-relative">
                            <div class="uk-inline input-position">
                                <form method="get" id="serach-form" action="/{{$lang}}/courses"
                                      class="uk-search uk-search-default">
                                    <a onclick="submitForm()" class="uk-form-icon-search"><img
                                                src="{{ asset('front/img/search.svg') }}"></a>
                                    <input value="" id="search" name="search" class="uk-input uk-input-search"
                                           type="text" placeholder="جست و جو ">
                                </form>
                            </div>
                            <div class="uk-inline">
                                <a class="uk-form-icon-filter" href="#modal-filter" uk-toggle><i class="material-icons">filter_list</i></a>
                                <input class="uk-input uk-input-filter" type="text" placeholder="فیلتر" disabled>
                            </div>
                            <div id="modal-filter" class="" uk-modal>
                                <div class="uk-modal-dialog uk-modal-body">
                                    <button class="uk-modal-close-default" type="button" uk-close></button>
                                    <ul class="uk-nav-default uk-nav-parent-icon" uk-nav>
                                        <li class="uk-parent uk-margin-medium-top">
                                            <a href="#" rel="nofollow">گروه آموزشی</a>
                                            <ul class="">
                                                <div class="">
                                                    <ul id="list-group">
                                                        @foreach($group as $key => $val)
                                                            <li onclick="insertParam('group' , '{{$key}}')"
                                                                value="{{$key}}">{{$val}}</li>
                                                        @endforeach
                                                    </ul>
                                                </div>
                                            </ul>
                                        </li>
                                        <li class="uk-parent uk-margin-medium-top">
                                            <a href="#" rel="nofollow"> برگزار کنندگان</a>
                                            <ul class="">
                                                <div class="">
                                                    <ul id="list-conductor">
                                                        @foreach($conductors as $value)
                                                            <li onclick="insertParam('conductor' , '{{$value->conductor_key}}')"
                                                                value="{{$value->conductor_key}}">{{$value->conductor}}</li>
                                                        @endforeach
                                                    </ul>
                                                </div>
                                            </ul>
                                        </li>
                                        <li class="uk-parent uk-margin-medium-top ">
                                            <a href="#" rel="nofollow"> گواهی پایان دوره</a>
                                            <ul class="">
                                                <div class="">
                                                    <ul id="list-certificate-filter" class=" no-padding-right">
                                                        <li><label><input checked class="uk-radio" type="radio"
                                                                          name="radio2"
                                                                          onclick="insertParam('certificate' , 'all')"
                                                                          value="all">همه</label></li>
                                                        <li><label><input class="uk-radio" type="radio" name="radio2"
                                                                          onclick="insertParam('certificate' , '1')"
                                                                          value="1">دارد</label></li>
                                                        <li><label><input class="uk-radio" type="radio" name="radio2"
                                                                          onclick="insertParam('certificate' , '0')"
                                                                          value="0"> ندارد</label></li>
                                                    </ul>
                                                </div>
                                            </ul>
                                        </li>
                                        <li class="uk-parent uk-margin-medium-top ">
                                            <a href="#" rel="nofollow"> امتیاز دوره</a>
                                            <ul class="">
                                                <div class="">
                                                    <ul id="rate" class=" no-padding-right">
                                                        <form class="rating">
                                                            <label>
                                                                <input type="radio" name="stars" value="1"/>
                                                                <span class="icon">★</span>
                                                            </label>
                                                            <label>
                                                                <input type="radio" name="stars" value="2"/>
                                                                <span class="icon">★</span>
                                                                <span class="icon">★</span>
                                                            </label>
                                                            <label>
                                                                <input type="radio" name="stars" value="3"/>
                                                                <span class="icon">★</span>
                                                                <span class="icon">★</span>
                                                                <span class="icon">★</span>
                                                            </label>
                                                            <label>
                                                                <input type="radio" name="stars" value="4"/>
                                                                <span class="icon">★</span>
                                                                <span class="icon">★</span>
                                                                <span class="icon">★</span>
                                                                <span class="icon">★</span>
                                                            </label>
                                                            <label>
                                                                <input type="radio" name="stars" value="5"/>
                                                                <span class="icon">★</span>
                                                                <span class="icon">★</span>
                                                                <span class="icon">★</span>
                                                                <span class="icon">★</span>
                                                                <span class="icon">★</span>
                                                            </label>
                                                        </form>
                                                    </ul>
                                                </div>
                                            </ul>
                                        </li>
                                        <li class="uk-parent uk-margin-medium-top">
                                            <a href="#" rel="nofollow">هزینه ثبت نام</a>
                                            <ul class="">
                                                <div class="">
                                                    <div id="slider-range"></div>
                                                    <p>
                                                        <label for="amount"></label>
                                                        <input type="text" id="amount" readonly class="input-price">
                                                        <input type="hidden" id="amount-hidden">
                                                    </p>
                                                </div>
                                            </ul>
                                        </li>
                                        <li class="uk-margin-medium-top">
                                            <button class="uk-button button-filter-course" id="submit-filter">تایید
                                            </button>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="uk-width-1-2 uk-text-right uk-margin-medium-top no-padding-right">
                        <p class="margin-right-label">جدیدترین دوره ها</p>
                    </div>
                    <div class="uk-width-1-2 uk-text-left uk-margin-medium-top no-padding-right">
                        <p class="padding-left-grid"><a href="/{{$lang}}/courses"> نمایش همه دوره ها </a><img
                                    src="{{ asset('front/img/arrow-left.svg') }}" alt=""></p>
                    </div>
                </div>
                <ul class="js-filter uk-child-width-1-2 uk-child-width-1-6@m uk-child-width-1-3@s uk-text-center course-list"
                    uk-grid>
                    @foreach($courses['newest']->items() as $value)
                        <li class="">
                            <a href="/{{$lang.'/course/'.$value->id}}">
                                <div class="uk-card uk-card-default">
                                    <div class="uk-card-media-top">
                                        <img src="{{$value->image}}" alt="{{$value->title.' - '.$loop->iteration}}">
                                    </div>
                                    <div class="uk-card-body">
                            <span class="course-title">
                              {{$value->title}}
                            </span>
                                        @if(intval($value->cost) > 0)
                                            <p>
                                                {{number_format(intval($value->cost))}}تومان
                                            </p>
                                        @else
                                            <p style="color: #0abcff">
                                                رایگان
                                            </p>
                                        @endif
                                    </div>
                                </div>
                            </a>
                        </li>
                    @endforeach
                </ul>
                <div class="uk-grid" uk-grid>
                    <div class="uk-width-1-2 uk-text-right uk-margin-medium-top no-padding-right">
                        <p class="margin-right-label"> بیشترین امتیاز دوره ها</p>
                    </div>
                    <div class="uk-width-1-2 uk-text-left uk-margin-medium-top no-padding-right">
                        <p class="padding-left-grid"><a href="/{{$lang}}/courses"> نمایش همه دوره ها </a><img
                                    src="{{ asset('front/img/arrow-left.svg') }}" alt=""></p>
                    </div>
                </div>
                <ul class="js-filter uk-child-width-1-2 uk-child-width-1-6@m uk-child-width-1-3@s uk-text-center course-list"
                    uk-grid>
                    @foreach($courses['most']->items() as $value)
                        <li class="">
                            <a href="/{{$lang.'/course/'.$value->id}}">
                                <div class="uk-card uk-card-default">
                                    <div class="uk-card-media-top">
                                        <img src="{{$value->image}}" alt="{{$value->title.' - '.$loop->iteration}}">
                                    </div>
                                    <div class="uk-card-body">
                            <span class="course-title">
                              {{$value->title}}
                            </span>
                                        @if(intval($value->cost) > 0)
                                            <p>
                                                {{number_format(intval($value->cost))}}تومان
                                            </p>
                                        @else
                                            <p style="color: #0abcff">
                                                رایگان
                                            </p>
                                        @endif
                                    </div>
                                </div>
                            </a>
                        </li>
                    @endforeach
                </ul>
                <div class="uk-grid" uk-grid>
                    <div class="uk-width-1-2 uk-text-right uk-margin-medium-top no-padding-right ">
                        <p class="margin-right-label">محبوب ترین دوره</p>
                    </div>
                    <div class="uk-width-1-2 uk-text-left uk-margin-medium-top no-padding-right">
                        <p class="padding-left-grid"><a href="/{{$lang}}/courses"> نمایش همه دوره ها </a><img
                                    src="{{ asset('front/img/arrow-left.svg') }}" alt=""></p>
                    </div>
                </div>
                <ul class="js-filter uk-child-width-1-2 uk-child-width-1-6@m uk-child-width-1-3@s uk-text-center course-list"
                    uk-grid>
                    @foreach($courses['popular']->items() as $value)
                        <li class="">
                            <a href="/{{$lang.'/course/'.$value->id}}">
                                <div class="uk-card uk-card-default">
                                    <div class="uk-card-media-top">
                                        <img src="{{$value->image}}" alt="{{$value->title.' - '.$loop->iteration}}">
                                    </div>
                                    <div class="uk-card-body">
                            <span class="course-title">
                              {{$value->title}}
                            </span>
                                        @if(intval($value->cost) > 0)
                                            <p>
                                                {{number_format(intval($value->cost))}}تومان
                                            </p>
                                        @else
                                            <p style="color: #0abcff">
                                                رایگان
                                            </p>
                                        @endif
                                    </div>
                                </div>
                            </a>
                        </li>
                    @endforeach
                </ul>
                <div class="uk-grid" uk-grid>
                    <div class="uk-width-1-2 uk-text-right uk-margin-medium-top no-padding-right">
                        <p class="margin-right-label">دوره های رایگان</p>
                    </div>
                    <div class="uk-width-1-2 uk-text-left uk-margin-medium-top no-padding-right">
                        <p class="padding-left-grid"><a href="/{{$lang}}/courses"> نمایش همه دوره ها </a><img
                                    src="{{ asset('front/img/arrow-left.svg') }}" alt=""></p>
                    </div>
                </div>
                <ul class="js-filter uk-child-width-1-2 uk-child-width-1-6@m uk-child-width-1-3@s uk-text-center course-list"
                    uk-grid>
                    @foreach($courses['free']->items() as $value)
                        <li class="">
                            <a href="/{{$lang.'/course/'.$value->id}}">
                                <div class="uk-card uk-card-default">
                                    <div class="uk-card-media-top">
                                        <img src="{{$value->image}}" alt="{{$value->title.' - '.$loop->iteration}}">
                                    </div>
                                    <div class="uk-card-body">
                            <span class="course-title">
                              {{$value->title}}
                            </span>
                                        @if(intval($value->cost) > 0)
                                            <p>
                                                {{number_format(intval($value->cost))}}تومان
                                            </p>
                                        @else
                                            <p style="color: #0abcff">
                                                رایگان
                                            </p>
                                        @endif
                                    </div>
                                </div>
                            </a>
                        </li>
                    @endforeach
                </ul>
            </div>
        </div>
    </section>

    <section id="pamphlet">
        <div class="uk-container">
            <div class="uk-grid" uk-grid>
                <div class="uk-width-1-2 uk-text-right uk-margin-medium-top no-padding-right">
                    <p class="margin-right-label">محتوای آموزشی</p>
                </div>
                <div class="uk-width-1-2 uk-text-left uk-margin-medium-top">
                    <p class="padding-left-grid"><a href="/{{$lang}}/courses"> نمایش همه دوره ها </a><img
                                src="{{ asset('front/img/arrow-left.svg') }}" alt=""></p>
                </div>
            </div>
            <div class="pamphlet">
                <div class="uk-grid no-margin-top" uk-grid>
                    @foreach($pamphlets as $value)
                        <div class="uk-width-1-4@xl uk-width-1-4@l uk-width-1-4@m uk-width-1-2">
                            <a href="/{{$lang.'/course/'.$value->id}}">
                                <div class="uk-card uk-card-default uk-card-body">
                                    @if ($value->type == 'movie')
                                        <i class="material-icons">movie</i>
                                    @elseif($value->type == 'doc')
                                        <i class="material-icons">import_contacts</i>
                                    @elseif($value->type == 'image')
                                        <i class="material-icons">insert_photo</i>
                                    @else
                                        <i class="material-icons">volume_up</i>
                                    @endif
                                    <span class="pamphlet-title blogtitle">{{$value->title}}</span>
                                    <p class="pamphlet-describe blogtitle">{{$value->description}}</p>
                                </div>
                            </a>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </section>

    <section id="map" class="uk-margin-medium-top uk-position-relative">
        <div class="uk-container">
            <div class="uk-grid" uk-grid>
                <div class="uk-width-1-2 uk-text-right uk-margin-medium-top no-padding-right">
                    <span class="margin-right-label">محل برگزاری</span>
                </div>
                <div class="uk-width-1-2 uk-text-left uk-margin-medium-top">
                    <span class=""><a href="/{{$lang}}/map"> نمایش همه </a><img
                                src="{{ asset('front/img/arrow-left.svg') }}" alt=""></span>
                </div>
            </div>
            <div class="map-color">
                <a href="/{{$lang}}/map">
                    <div class="map">
                        <div class="uk-text-center">
                            <img class="blink-image" src="{{ asset('front/img/mark.svg') }}" alt="">
                        </div>
                    </div>
                </a>
            </div>
        </div>
    </section>

    <section id="conductor">
        <div class="uk-container uk-text-center">
            <div class="uk-grid" uk-grid>
                <div class="uk-width-1-2 uk-text-right uk-margin-medium-top no-padding-right">
                    <p class="margin-right-label">برگزار کنندگان دوره های آموزشی</p>
                </div>
                <div class="uk-width-1-2 uk-text-left uk-margin-medium-top">
                    <p class="padding-left-grid"><a href="/{{$lang}}/conductors"> نمایش همه </a><img
                                src="{{ asset('front/img/arrow-left.svg') }}" alt=""></p>
                </div>
            </div>
            <div class="uk-grid uk-hidden@l background-user">
                @foreach($conductors_slider as $conductor)
                    <div class="uk-width-1-6@m uk-width-1-4@s uk-width-1-3 ">
                        <div class="img-conductor" uk-tooltip="title: {{$conductor->conductor}}; pos: right">
                            <img src="{{$conductor->logo}}" alt="{{$conductor->conductor}}">
                        </div>
                    </div>
                @endforeach
            </div>
            <div class="demo-grid-ruler mdl-grid background-user margin-top uk-visible@l">
                @foreach($conductors_slider as $conductor)
                    <div class="mdl-cell mdl-cell--1-col">
                        <div class="img-conductor" uk-tooltip="title: {{$conductor->conductor}}; pos: right">
                            <img src="{{$conductor->logo}}" alt="{{$conductor->conductor}}">
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </section>

    <section id="teacher">
        <div class="uk-container uk-text-center">
            <div class="uk-grid" uk-grid>
                <div class="uk-width-1-2 uk-text-right uk-margin-medium-top no-padding-right">
                    <p class="margin-right-label">مدرسان دوره های آموزشی</p>
                </div>
                <div class="uk-width-1-2 uk-text-left uk-margin-medium-top">
                    <p class="padding-left-grid"><a href="/{{$lang}}/teachers"> نمایش همه </a><img
                                src="{{ asset('front/img/arrow-left.svg') }}" alt=""></p>
                </div>
            </div>
            <div class="uk-grid uk-hidden@l background-user">
                @foreach($teachers as $teacher)
                    @if($teacher->avatar != null)
                        <div class="uk-width-1-6@m uk-width-1-4@s uk-width-1-3 ">
                            <div class="img-conductor" uk-tooltip="title: {{$teacher->full_name}}; pos: right">
                                <img src="{{$teacher->avatar}}" alt="{{$teacher->full_name}}">
                            </div>
                        </div>
                    @endif
                @endforeach
            </div>
            <div class="demo-grid-ruler mdl-grid background-user margin-top uk-visible@l">
                @foreach($teachers as $teacher)
                    @if($teacher->avatar != null)
                        <div class="mdl-cell mdl-cell--1-col mdl-cell--3-col-phone">
                            <div class="img-conductor" uk-tooltip="title: {{$teacher->full_name}}; pos: right">
                                <img src="{{$teacher->avatar}}" alt="{{$teacher->full_name}}">
                            </div>
                        </div>
                    @endif
                @endforeach
            </div>
        </div>
    </section>

    <section id="blog" class="">
        <div class="uk-container">
            <div class="uk-grid" uk-grid>
                <div class="uk-width-1-2 uk-text-right uk-margin-medium-top">
                    <p class="margin-right-label">وبلاگ و اخبار</p>
                </div>
                <div class="uk-width-1-2 uk-text-left uk-margin-medium-top">
                    <p class="padding-left-grid"><a href="/{{$lang}}/blog"> نمایش همه </a><img
                                src="{{ asset('front/img/arrow-left.svg') }}" alt=""></p>
                </div>
            </div>
            <div class="uk-grid" uk-grid>
                @foreach($blog as $value)
                    <div class="uk-width-1-6@xl uk-width-1-6@l uk-width-1-3@m uk-width-1-2@s">
                        <a href="/content/{{$value->id}}/{{App::getLocale()}}" rel="nofollow">
                            <div class="uk-card uk-card-default">
                                <div class="uk-card-media-top">
                                    <img src="{{asset('images/article/thumbs/380/'.$value->image)}}"
                                         alt="{{$value->title}}">
                                </div>
                                <div class="uk-card-body">
                                    <h4 class="uk-card-title blogtitle">{{$value->title}}</h4>
                                    <p class="blog-description blogdescription">{{$value->description}}</p>
                                </div>
                            </div>
                        </a>
                    </div>
                @endforeach
            </div>
        </div>
    </section>
@endsection

@section('footer')
    <script>
        function submitForm() {
            window.location = '/fa/courses?search=' + $("#search").val();
        }

        var arrayKeys = [];
        var arrayParams = [];

        function insertParam(key, value) {
            if (key != 'amount' && key != 'certificate' && key != 'rate') {
                var index = arrayParams.indexOf(value);
                if (index > -1) {
                    arrayKeys.splice(index, 1);
                    arrayParams.splice(index, 1);
                } else {
                    arrayKeys.push(key);
                    arrayParams.push(value);
                }
            } else {
                arrayKeys.push(key);
                arrayParams.push(value);
            }

            $('#submit-filter').click(function () {
                var group = 'group=';
                var conductor = 'conductor=';
                var teacher = 'teacher=';
                var certificate = '';
                var amount = '';
                var rate = '';
                for (var i = 0; i < arrayKeys.length; i++) {
                    if (arrayKeys[i] == 'group') {
                        if (group == 'group=') {
                            group = group + arrayParams[i];
                        } else {
                            group = group + ',' + arrayParams[i];
                        }
                    }
                    if (arrayKeys[i] == 'conductor') {
                        if (conductor == 'conductor=') {
                            conductor = conductor + arrayParams[i];
                        } else {
                            conductor = conductor + ',' + arrayParams[i];
                        }
                    }
                    if (arrayKeys[i] == 'teacher') {
                        if (teacher == 'teacher=') {
                            teacher = teacher + arrayParams[i];
                        } else {
                            teacher = teacher + ',' + arrayParams[i];
                        }
                    }
                    if (arrayKeys[i] == 'certificate') {
                        certificate = 'certificate=' + arrayParams[i];
                    }
                    if (arrayKeys[i] == 'amount') {
                        amount = 'amount=' + arrayParams[i];
                    }
                    if (arrayKeys[i] == 'rate') {
                        rate = 'rate=' + arrayParams[i];
                    }

                }
                var QueryParams = '';
                if (group != 'group=') {
                    QueryParams = group;
                }
                if (conductor != 'conductor=') {
                    QueryParams = QueryParams + '&' + conductor;
                }
                if (teacher != 'teacher=') {
                    QueryParams = QueryParams + '&' + teacher;
                }
                if (certificate != '') {
                    QueryParams = QueryParams + '&' + certificate;
                }
                if (amount != '') {
                    QueryParams = QueryParams + '&' + amount;
                }
                if (rate != '') {
                    QueryParams = QueryParams + '&' + rate;
                }

                window.location = '/fa/courses?' + QueryParams;
            });
        }

        $(':radio').change(function () {
            insertParam('rate', this.value);
        });
    </script>
@endsection


