@extends('layouts.home')

@section('content')
    <section id="courses">
        <div class="uk-container">
            <div uk-filter="target: .js-filter">
                <div class="uk-grid" uk-grid>
                    <div class="uk-width-1-1 uk-text-right uk-margin-medium-top no-padding-right">
                        <p class="margin-right-label">نمایش همه دوره ها</p>
                    </div>
                </div>
                <ul class="js-filter uk-child-width-1-2 uk-child-width-1-6@m uk-child-width-1-3@s uk-text-center course-list uk-hidden@xl" uk-grid>
                    @foreach($courses as $value)
                        <li class="">
                            <a href="/{{$lang.'/course/'.$value->id}}">
                                <div class="uk-card uk-card-default">
                                    <div class="uk-card-media-top">
                                        <img src="{{$value->image}}" alt="{{$value->title.' - '.$loop->iteration}}">
                                    </div>
                                    <div class="uk-card-body">
                            <span class="course-title">
                              {{$value->title}}
                            </span>
                                        @if(intval($value->cost) > 0)
                                            <p>
                                                {{number_format(intval($value->cost))}} تومان
                                            </p>
                                        @else
                                            <p style="color: #0abcff">
                                                رایگان
                                            </p>
                                        @endif
                                    </div>
                                </div>
                            </a>
                        </li>
                    @endforeach
                </ul>
                <ul class="demo-grid-ruler mdl-grid js-filter uk-text-center course-list uk-visible@xl">
                    @foreach($courses as $value)
                        <li class="mdl-cell mdl-cell--1-col">
                            <a href="/{{$lang.'/course/'.$value->id}}">
                                <div class="uk-card uk-card-default">
                                    <div class="uk-card-media-top">
                                        <img src="{{$value->image}}" alt="{{$value->title.' - '.$loop->iteration}}">
                                    </div>
                                    <div class="uk-card-body">
                            <span class="course-title">
                              {{$value->title}}
                            </span>
                                        @if(intval($value->cost) > 0)
                                            <p>
                                                {{number_format(intval($value->cost))}}تومان
                                            </p>
                                        @else
                                            <p style="color: #0abcff">
                                                رایگان
                                            </p>
                                        @endif
                                    </div>
                                </div>
                            </a>
                        </li>
                    @endforeach
                </ul>
{{--                <div class="uk-grid" uk-grid>--}}
{{--                    <div class="uk-width-1-1 uk-text-right uk-margin-medium-top no-padding-right">--}}
{{--                        <p class="margin-right-label">بیشترین امتیاز دوره ها</p>--}}
{{--                    </div>--}}
{{--                </div>--}}
{{--                <ul class="js-filter uk-child-width-1-2 uk-child-width-1-6@m uk-child-width-1-3@s uk-text-center course-list uk-hidden@xl" uk-grid>--}}
{{--                    @foreach($courses as $value)--}}
{{--                        <li class="">--}}
{{--                            <a href="/{{$lang.'/course/'.$value->id}}">--}}
{{--                                <div class="uk-card uk-card-default">--}}
{{--                                    <div class="uk-card-media-top">--}}
{{--                                        <img src="{{$value->image}}" alt="{{$value->title.' - '.$loop->iteration}}">--}}
{{--                                    </div>--}}
{{--                                    <div class="uk-card-body">--}}
{{--                            <span class="course-title">--}}
{{--                              {{$value->title}}--}}
{{--                            </span>--}}
{{--                                        <p>--}}
{{--                                            {{number_format(intval($value->cost))}}تومان--}}
{{--                                        </p>--}}
{{--                                    </div>--}}
{{--                                </div>--}}
{{--                            </a>--}}
{{--                        </li>--}}
{{--                    @endforeach--}}
{{--                </ul>--}}
{{--                <ul class="demo-grid-ruler mdl-grid js-filter uk-text-center course-list uk-visible@xl">--}}
{{--                    @foreach($courses as $value)--}}
{{--                        <li class="mdl-cell mdl-cell--1-col">--}}
{{--                            <a href="/{{$lang.'/course/'.$value->id}}">--}}
{{--                                <div class="uk-card uk-card-default">--}}
{{--                                    <div class="uk-card-media-top">--}}
{{--                                        <img src="{{$value->image}}" alt="{{$value->title.' - '.$loop->iteration}}">--}}
{{--                                    </div>--}}
{{--                                    <div class="uk-card-body">--}}
{{--                            <span class="course-title">--}}
{{--                              {{$value->title}}--}}
{{--                            </span>--}}
{{--                                        <p>--}}
{{--                                            {{number_format(intval($value->cost))}}تومان--}}
{{--                                        </p>--}}
{{--                                    </div>--}}
{{--                                </div>--}}
{{--                            </a>--}}
{{--                        </li>--}}
{{--                    @endforeach--}}
{{--                </ul>--}}
{{--                <div class="uk-grid" uk-grid>--}}
{{--                    <div class="uk-width-1-1 uk-text-right uk-margin-medium-top no-padding-right">--}}
{{--                        <p class="margin-right-label">محبوب ترین دوره ها</p>--}}
{{--                    </div>--}}
{{--                </div>--}}
{{--                <ul class="js-filter uk-child-width-1-2 uk-child-width-1-6@m uk-child-width-1-3@s uk-text-center course-list uk-hidden@xl" uk-grid>--}}
{{--                    @foreach($courses as $value)--}}
{{--                        <li class="">--}}
{{--                            <a href="/{{$lang.'/course/'.$value->id}}">--}}
{{--                                <div class="uk-card uk-card-default">--}}
{{--                                    <div class="uk-card-media-top">--}}
{{--                                        <img src="{{$value->image}}" alt="{{$value->title.' - '.$loop->iteration}}">--}}
{{--                                    </div>--}}
{{--                                    <div class="uk-card-body">--}}
{{--                            <span class="course-title">--}}
{{--                              {{$value->title}}--}}
{{--                            </span>--}}
{{--                                        <p>--}}
{{--                                            {{number_format(intval($value->cost))}}تومان--}}
{{--                                        </p>--}}
{{--                                    </div>--}}
{{--                                </div>--}}
{{--                            </a>--}}
{{--                        </li>--}}
{{--                    @endforeach--}}
{{--                </ul>--}}
{{--                <ul class="demo-grid-ruler mdl-grid js-filter uk-text-center course-list uk-visible@xl">--}}
{{--                    @foreach($courses as $value)--}}
{{--                        <li class="mdl-cell mdl-cell--1-col">--}}
{{--                            <a href="/{{$lang.'/course/'.$value->id}}">--}}
{{--                                <div class="uk-card uk-card-default">--}}
{{--                                    <div class="uk-card-media-top">--}}
{{--                                        <img src="{{$value->image}}" alt="{{$value->title.' - '.$loop->iteration}}">--}}
{{--                                    </div>--}}
{{--                                    <div class="uk-card-body">--}}
{{--                            <span class="course-title">--}}
{{--                              {{$value->title}}--}}
{{--                            </span>--}}
{{--                                        <p>--}}
{{--                                            {{number_format(intval($value->cost))}}تومان--}}
{{--                                        </p>--}}
{{--                                    </div>--}}
{{--                                </div>--}}
{{--                            </a>--}}
{{--                        </li>--}}
{{--                    @endforeach--}}
{{--                </ul>--}}
{{--                <div class="uk-grid" uk-grid>--}}
{{--                    <div class="uk-width-1-1 uk-text-right uk-margin-medium-top no-padding-right">--}}
{{--                        <p class="margin-right-label">دوره های رایگان</p>--}}
{{--                    </div>--}}
{{--                </div>--}}
{{--                <ul class="js-filter uk-child-width-1-2 uk-child-width-1-6@m uk-child-width-1-3@s uk-text-center course-list uk-hidden@xl" uk-grid>--}}
{{--                    @foreach($courses as $value)--}}
{{--                        <li class="">--}}
{{--                            <a href="/{{$lang.'/course/'.$value->id}}">--}}
{{--                                <div class="uk-card uk-card-default">--}}
{{--                                    <div class="uk-card-media-top">--}}
{{--                                        <img src="{{$value->image}}" alt="{{$value->title.' - '.$loop->iteration}}">--}}
{{--                                    </div>--}}
{{--                                    <div class="uk-card-body">--}}
{{--                            <span class="course-title">--}}
{{--                              {{$value->title}}--}}
{{--                            </span>--}}
{{--                                        <p>--}}
{{--                                            {{number_format(intval($value->cost))}}تومان--}}
{{--                                        </p>--}}
{{--                                    </div>--}}
{{--                                </div>--}}
{{--                            </a>--}}
{{--                        </li>--}}
{{--                    @endforeach--}}
{{--                </ul>--}}
{{--                <ul class="demo-grid-ruler mdl-grid js-filter uk-text-center course-list uk-visible@xl">--}}
{{--                    @foreach($courses as $value)--}}
{{--                        <li class="mdl-cell mdl-cell--1-col">--}}
{{--                            <a href="/{{$lang.'/course/'.$value->id}}">--}}
{{--                                <div class="uk-card uk-card-default">--}}
{{--                                    <div class="uk-card-media-top">--}}
{{--                                        <img src="{{$value->image}}" alt="{{$value->title.' - '.$loop->iteration}}">--}}
{{--                                    </div>--}}
{{--                                    <div class="uk-card-body">--}}
{{--                            <span class="course-title">--}}
{{--                              {{$value->title}}--}}
{{--                            </span>--}}
{{--                                        <p>--}}
{{--                                            {{number_format(intval($value->cost))}}تومان--}}
{{--                                        </p>--}}
{{--                                    </div>--}}
{{--                                </div>--}}
{{--                            </a>--}}
{{--                        </li>--}}
{{--                    @endforeach--}}
{{--                </ul>--}}
            </div>
        </div>
       <div class="uk-width-1-1 uk-text-center uk-margin-large-top">
           {{ $courses->appends(request()->except('page'))->links() }}
       </div>
    </section>

@endsection

@section('footer')
    <script>
        function submitForm(){insertParam("search",$("#search").val())}function insertParam(t,e){t=encodeURI(t),e=encodeURI(e);for(var n,i=document.location.search.substr(1).split("&"),c=i.length;c--;)if((n=i[c].split("="))[0]==t){if("amount"==n[0]||"search"==n[0]||"certificate"==n[0]||"course_type"==n[0]||"sort"==n[0])n[1]=e;else{values=n[1].split(",");var o=values.indexOf(e);-1==o?n[1]=n[1]+","+e:(values.splice(o,1),values.length>1?n[1]=values.join():1==values.length?n[1]=values:n=null)}null!==n?i[c]=n.join("="):i.splice(c,1);break}c<0&&(i[i.length]=[t,e].join("=")),document.location.search=i.join("&")}$(document).ready(function(){$("#list-conductor").multiList(),$("#list-conductor").on("multiList.elementChecked",function(t,e,n){}),$("#list-conductor").on("multiList.elementUnchecked",function(t,e,n){}),$("#list-conductor").trigger("multiList.elementChecked")}),$(document).ready(function(){$("#list-group").multiList(),$("#list-group").on("multiList.elementChecked",function(t,e,n){}),$("#list-group").on("multiList.elementUnchecked",function(t,e,n){}),$("#list-group").trigger("multiList.elementChecked")}),$(document).ready(function(){$("#list-conductor-convas").multiList(),$("#list-conductor-convas").on("multiList.elementChecked",function(t,e,n){}),$("#list-conductor-convas").on("multiList.elementUnchecked",function(t,e,n){}),$("#list-conductor-convas").trigger("multiList.elementChecked")}),$(document).ready(function(){$("#list-group-convas").multiList(),$("#list-group-convas").on("multiList.elementChecked",function(t,e,n){}),$("#list-group-convas").on("multiList.elementUnchecked",function(t,e,n){}),$("#list-group-convas").trigger("multiList.elementChecked")}),setTimeout(function(){$("li.checked > input").attr("checked","checked")},1e3);
    </script>
@endsection
