@extends('layouts.pages')

@section('PageTitle')
    {{$page_title}}
@endsection

@section('meta_description')
    {{$description}}
@endsection

@section('content')
    <section id="course-info" class="uk-margin-medium-top">
        <div class="uk-container uk-container-expand">
            <div class="course-info">
                <div  uk-grid>
                    <div class="uk-width-1-2@m uk-width-1-1">
                        <div class="">
                            <table class="uk-table uk-table-divider">
                                <tbody>
                                <tr>
                                    <td>
                                        <ul class="ul-course-info">
                                            <li><h1 class="h3-course">{{$course->title}}</h1></li>
                                            <li><h4 class="h4-course">{{$course->description}}</h4></li>
                                        </ul>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                   <span class="label-info">
                                       پیش نمایش
                                   </span>
                                    </td>
                                </tr>
                                <tr style="    border-bottom: 1px solid #e5e5e5;">
                                    <td>
                                        <li>
                                            <p>
                                                <span class=""> هزینه ثبت نام :</span>
                                                @if(intval($course->cost) > 0)
                                                    <span class="price-course">{{number_format(intval($course->cost))}}تومان </span>
                                                @else
                                                    <span class="price-course">رایگان</span>
                                                @endif

                                                <a target="_blank" rel="nofollow" href="{{ $course->base_url.'course/'.$course->course_key }}"><button class="uk-button register-button" rel="nofollow">مشاهده دوره</button></a>
                                            </p>
                                        </li>
                                    </td>
                                </tr>
                                </tbody>
                            </table>
                            <ul class="ul-course-info">
                                <li><h4 class="tabel-title">مشخصات دوره</h4></li>
                            </ul>
                            <table class="uk-table uk-table-divider">
                                <tbody>
                                <tr>
                                    <td>
                                    <span class="label-info">
                                         دسته بندی
                                    </span>

                                        <span class="span-course-info">{{ $course->group }}</span>
                                    </td>
                                    <td>
                                    <span class="label-info">
                                         کد دوره
                                    </span>

                                        <span class="span-course-info">{{ $course->course_key }}</span>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                    <span class="label-info">
                                         نوع دوره
                                    </span>

                                        <span class="span-course-info">{{ $course->type }}</span>
                                    </td>
                                    <td>
                                    <span class="label-info">
                                        نوع برگزاری
                                    </span>

                                        <span class="span-course-info">{{ $course->level }}</span>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                    <span class="label-info">
                                        گواهی پایان دوره
                                    </span>

                                        <span class="span-course-info">@if($course->certificate == 1) {{ $course->certificate_title }} @else ندارد @endif</span>
                                    </td>
                                    <td>
                                    <span class="label-info">
                                        هزینه ثبت نام
                                    </span>
                                        @if(intval($course->cost) > 0)
                                            <span class="span-course-info">{{number_format(intval($course->cost))}}تومان</span>
                                        @else
                                            <span class="span-course-info">رایگان</span>
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                    <span class="label-info">
                                        مدت دوره
                                    </span>

                                        <span class="span-course-info"> {{ $course->duration }} روز</span>
                                    </td>
                                    <td>
                                </tr>
                                <tr>
                                    <td>
                                    <span class="label-info">
                                        تاریخ شروع
                                    </span>
                                        <span class="span-course-info">{{\App\Traits\Date::dateView($course->date_start , $lang)}}</span>

                                    </td>
                                    <td>
                                    <span class="label-info">
                                         تاریخ پایان
                                    </span>


                                        <span class="span-course-info">{{\App\Traits\Date::dateView($course->date_end , $lang)}}</span>
                                    </td>
                                </tr>
                                <tr style="    border-bottom: 1px solid #e5e5e5;">
                                    <td>
                                    <span class="label-info">
                                        تاریخ امتحان
                                    </span>
                                        <span class="span-course-info">@if($course->date_quiz != '') {{\App\Traits\Date::dateView($course->date_quiz , $lang)}} @else - @endif</span>
                                    </td>
                                    <td>
                                    <span class="label-info">
                                        مهلت ثبت نام
                                    </span>

                                        <span class="span-course-info">@if($course->date_register != '') {{\App\Traits\Date::dateView($course->date_register , $lang)}} @else - @endif</span>
                                    </td>
                                </tr>

                                </tbody>
                            </table>
{{--                            <table class="uk-table uk-table-divider">--}}
{{--                                <tbody>--}}
{{--                                <tr>--}}
{{--                                    <td>--}}
{{--                                    <span class="tabel-title">--}}
{{--                                       اهداف دوره--}}
{{--                                    </span><br>--}}
{{--                                        <span class="span-course-info"> نفر</span>--}}
{{--                                    </td>--}}
{{--                                </tr>--}}
{{--                                <tr>--}}
{{--                                    <td>--}}
{{--                                    <span class="tabel-title">--}}
{{--                                       مفاد درسی--}}
{{--                                    </span><br>--}}
{{--                                        <span class="span-course-info"> نفر</span>--}}
{{--                                    </td>--}}
{{--                                </tr>--}}
{{--                                <tr>--}}
{{--                                    <td>--}}
{{--                                    <span class="tabel-title">--}}
{{--                                       پیش نیاز--}}
{{--                                    </span><br>--}}
{{--                                        <span class="span-course-info"> نفر</span>--}}
{{--                                    </td>--}}
{{--                                </tr>--}}
{{--                                <tr>--}}
{{--                                    <td>--}}
{{--                                    <span class="tabel-title">--}}
{{--                                       وسایل مورد نیاز--}}
{{--                                    </span><br>--}}
{{--                                        <span class="span-course-info"> نفر</span>--}}
{{--                                    </td>--}}
{{--                                </tr>--}}
{{--                                </tbody>--}}
{{--                            </table>--}}

                        </div>
                    </div>
                    <div class="uk-width-1-2@m uk-width-1-1">
                        <div class="">
                            <ul class="border-bottom-list">
                                <li>
                                    <img src="{{$course->image}}" alt="{{$course->title}}" class="uk-margin-medium-top">
                                </li>
                            </ul>
                            <ul class="border-bottom-list">
                                <li><h3 class="tabel-title">محل برگزاری</h3></li>
                                <li>
                                    <div class="">
                                        <div id="map" class="course-map" data-lat="{{ $course->lat }}" data-lng="{{ $course->long }}"></div>
                                    </div>
                                </li>
                            </ul>
                            <ul class="border-bottom-list teacher-course-list">
                                <li> <h3 class="tabel-title">مدرسان</h3></li>
                                <li class="li-course-teacher">
                                    @foreach($teachers as $teacher)
                                        @if($teacher->avatar == 0)
                                            <img src="/images/no-image-avatar.jpg" class="course-teacher" alt="{{ $teacher->first_name.' '.$teacher->last_name }}" title="{{ $teacher->first_name.' '.$teacher->last_name }}">
                                        @else
                                            <img src="{{ $teacher->avatar }}" class="course-teacher" alt="{{ $teacher->first_name.' '.$teacher->last_name }}" title="{{ $teacher->first_name.' '.$teacher->last_name }}">
                                        @endif
                                    @endforeach
                                </li>
                            </ul>
                            <ul class="">
                                <li> <h3 class="tabel-title">محتوای آموزشی</h3></li>
                                <li><i class="material-icons">import_contacts</i><span class="pamphlet-course">نمایش محتوای آموزشی</span><a href="{{ $course->base_url.'register_course/'.$course->course_key }}"><span class="download-pamphlet"><i class="material-icons">arrow_downward</i> دانلود</span></a></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection

@section('footer')
    <script>
        function initMap() {
            var lat = $('#map').attr('data-lat') * 1;
            var lng = $('#map').attr('data-lng') * 1;
            var LatLng = {lat: lat , lng: lng};
            var map = new google.maps.Map(document.getElementById('map'), {
                center: LatLng,
                zoom: 14
            });
            var marker = new google.maps.Marker({
                position: LatLng,
                map: map
            });
        }
    </script>
    <script async defer src="https://maps.googleapis.com/maps/api/js?key=AIzaSyBiNxZ5LX7rFmDJhMtLjgfgBGTleCs5rEM&callback=initMap" type="text/javascript"></script>
@endsection
