@extends('layouts.pages')

@section('content')
    <section id="conductor" class="uk-margin-large-top">
        <div class="uk-container uk-text-center">
            <div class="uk-grid" uk-grid>
                <div class="uk-width-1-2 uk-text-right uk-margin-medium-top no-padding-right">
                    <p class="margin-right-label">برگزار کنندگان دوره های آموزشی</p>
                </div>
            </div>
            <div class="uk-grid\ uk-hidden@l background-user">
                @foreach($conductors as $conductor)
                    <div class="uk-width-1-6@m uk-width-1-4@s uk-width-1-3 uk-text-center">
                       <a href="{{$conductor->base_url}}" uk-tooltip="title: {{$conductor->conductor}}; pos: right">
                           <div class="img-conductor" >
                               <img src="{{$conductor->logo}}" alt="{{$conductor->conductor}}">
                           </div>
                           <span class="blogtitle">{{$conductor->conductor}}</span>
                       </a>
                    </div>
                @endforeach
            </div>
            <div class="demo-grid-ruler mdl-grid background-user margin-top uk-visible@l uk-text-center">
                @foreach($conductors as $conductor)
                    <div class="mdl-cell mdl-cell--1-col">
                        <a href="{{$conductor->base_url}}" uk-tooltip="title: {{$conductor->conductor}}; pos: right">
                            <div class="img-conductor">
                                <img src="{{$conductor->logo}}" alt="{{$conductor->conductor}}">
                            </div>
                            <span class="blogtitle">{{$conductor->conductor}}</span>
                        </a>
                    </div>
                @endforeach
            </div>
        </div>
        <div class="uk-width-1-1 uk-text-center uk-margin-large-top">
            {{ $conductors->appends(request()->except('page'))->links() }}
        </div>
    </section>
@endsection

@section('footer')
    <script type="text/javascript">
        jQuery(function() {
            var minimized_title = $('.blogtitle');
            minimized_title.each(function() {
                var t = $(this).text();
                if (t.length < 10) return;
                $(this).html(t.slice(0, 10) + '<span>... </span>' + '<span class="hide">' + t.slice(10, t.length) + '</span>')
            })
        });
    </script>
@endsection
