@extends('layouts.pages')

@section('content')
    <section id="blogs" class="">
        <div class="uk-container">
            <div class="uk-grid" uk-grid>
                <div class="uk-width-1-1 uk-text-center uk-margin-medium-top">
                    <img src="{{ asset('front/img/blogs.png') }}" alt="">
                </div>
            </div>
            <div class="uk-grid" uk-grid>
                <div class="uk-width-1-1 uk-text-center uk-margin-medium-top">
                    <p class="">وبلاگ و اخبار</p>
                </div>
            </div>
            <div class="uk-grid padding-inner-pages uk-margin-small-top" uk-grid>
                @foreach ($data as $value)
                    <div class="uk-width-1-6@xl uk-width-1-6@l uk-width-1-3@m uk-width-1-2@s">
                        <a href="{{route('blog',[$value->slug,App::getLocale()])}}">
                            <div class="uk-card uk-card-default">
                                <div class="uk-card-media-top">
                                    <img src="{{asset('images/article/thumbs/380/'.$value->image)}}" alt="{{$value->title}}">
                                </div>
                                <div class="uk-card-body">
                                    <h4 class="uk-card-title blogtitle">{{$value->title}}</h4>
                                    <p class="blog-description blogdescription">{{$value->description}}</p>
                                </div>
                            </div>
                        </a>
                    </div>
                @endforeach
            </div>
            <div class="uk-width-1-1 uk-text-center" style="margin-top: 30px;">
                {{ $data->links() }}
            </div>
        </div>
    </section>
@endsection

@section('footer')
    <script type="text/javascript">
        jQuery(function() {
            var minimized_title = $('.blogtitle');
            minimized_title.each(function() {
                var t = $(this).text();
                if (t.length < 15) return;
                $(this).html(t.slice(0, 15) + '<span>... </span>' + '<span class="hide">' + t.slice(15, t.length) + '</span>')
            })
            var minimized_title = $('.blogdescription');
            minimized_title.each(function() {
                var t = $(this).text();
                if (t.length < 90) return;
                $(this).html(t.slice(0, 90) + '<span>... </span>' + '<span class="hide">' + t.slice(90, t.length) + '</span>')
            })
        });
    </script>
@endsection