@extends('layouts.pages')
{{--title--}}
@section('PageTitle')
    {{$data->title}}
@endsection
{{--end title--}}

{{--keywords--}}
@section('keywords'){{$data->keyword}}@endsection


{{--meta description--}}
@section('meta_description'){{$data->meta_description}}@endsection


@section('content')
    <section id="blog-details" class="uk-margin-large-top">
        <div class="uk-container">
            <div class="blog-details">
                <div class="uk-grid" uk-grid>
                    <div class="uk-width-1-3@s">
                        <img class="uk-margin-medium-bottom" src="{{asset('images/article/'.$data->image)}}" alt="{{$data->title}}">
                    </div>
                    <div class="uk-width-2-3@s">
                        <article class="uk-article uk-margin-medium-top">
                            <h1 class="uk-article-title">{{$data->title}}</h1>
                            <p class="uk-article-meta">
                                <span class="padding-right-15" uk-icon="pencil"> نویسنده : یکیتا </span>
                            </p>
                            <p> {!! html_entity_decode($data->content) !!}</p>
                            <p class="comment-title" id="comment">نظرات کاربران</p>
                            @if(session()->has('message'))
                                <div class="alert alert-success">
                                    {{ session()->get('message') }}
                                </div>
                            @endif
                            <div class="uk-grid">
                                <div class="uk-width-1-2 no-padding-right">
                                    <ul class="users-comment">
                                        @foreach ($comments as $comment)
                                        <li>
                                            <img src="{{ asset('front/img/user-comment.png') }}" class="" alt="user"> <label>{{$comment->fullname}}</label><br>
                                            <p class="detail">{{$comment->body}}</p>
                                        </li>
                                        @endforeach
                                    </ul>
                                </div>
                                <div class="uk-width-1-1 no-padding-right" >
                                    <ul class="">
                                        <li><img src="{{ asset('front/img/sms.png') }}" class="" alt="sms"> <label>نظر خود را بنویسید</label></li>
                                        <li class="uk-float-right">
                                            <div class="uk-inline">
                                                <form action={{route('store_comment')}} method="post">
                                                    @csrf
                                                    <input class="uk-input uk-input-send md-input{{ $errors->has('fullname') ? ' md-input-danger' : '' }}" type="text" name="fullname" id="fullname" placeholder="نام شما">
                                                    @if ($errors->has('fullname'))
                                                        <span class="span-error" role="alert">
                                                        <span class="uk-alert-danger">{{ $errors->first('fullname') }}</span>
                                                    </span>
                                                    @endif
                                                    <input class="uk-input uk-input-send md-input{{ $errors->has('body') ? ' md-input-danger' : '' }}" type="text" name="body" id="body" placeholder="نظر خود را بنویسید">
                                                    @if ($errors->has('body'))
                                                        <span class="span-error" role="alert">
                                                        <span class="uk-alert-danger">{{ $errors->first('body') }}</span>
                                                    </span>
                                                    @endif
                                                    <input class="uk-input uk-input-send" type="hidden" name="blog_id" id="blog_id" value="{{$data->blog_id}}">
                                                    <button class="submit-comment" name="submit" id="submit"><i class="material-icons-send">navigation</i></button>
                                                </form>
                                            </div>
                                        </li>
                                        <li class="user-activity uk-float-left">
                                            <i class="material-icons">
                                                sentiment_very_dissatisfied
                                            </i>
                                            <i class="material-icons">
                                                share
                                            </i>
                                            <i class="material-icons">
                                                visibility
                                            </i>
                                            <i class="material-icons">
                                                favorite_border
                                            </i>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </article>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection

@section('footer')
    <script>
        $(document).ready(function(){
            $('article img').addClass('img-responsive');
            $('article a').addClass('display-a');
        });
    </script>
@endsection
