@extends('layouts.buy')


@section('content')
    <div id="login-form">
        <div class="uk-container uk-container-expand uk-margin-medium-top">
            <div uk-grid>
                <div class="uk-width-xlarge@s uk-width-large uk-margin margin-auto" >
                    <div class="login-card">
                        
<!-- hmp creat -->
                        <div class="uk-grid header-page uk-flex uk-flex-between">
                            <div class="uk-width-1-4">
                                <i class="material-icons">language</i>
                            </div>
                            <div class="uk-width-2-4 navbar-payment uk-position-top-center"> 
                                    <!-- This is a button toggling the modal -->
                                <button class="uk-button button-oauth" type="button">
                                    <div class="uk-grid navbar-payment-content">
                                        <div class="no-padding uk-flex-inline uk-flex-between">
                                            <img src="/media/images/avatar/KNgGqGw3ZN_1597662523.jpg" class="image-user">
                                            <p class="name-user">
                                                {{session()->get('user_information')->name}} 
                                            </p>
                                            <p class="type-user">
                                                برگزار کننده
                                            </p>
                                        </div>
                                        <div class="no-padding" style="margin-top: .5rem;">
                                            
                                        </div>
                                    </div>
                                </button>
                            </div>
                            <div class="uk-width-1-4 uk-text-left">
                                <a href="{{route('home_basket_information')}}"><i class="material-icons">arrow_back</i></a>
                            </div>
                        </div>

                        @if(session()->has('message'))
                            <div class="uk-alert-warning" uk-alert>
                                <a class="uk-alert-close" uk-close></a>
                                <p>{{ session()->get('message') }}</p>
                            </div>
                        @endif

                        @if ($errors->has('rules'))
                            <div class="uk-alert-warning" uk-alert>
                                <a class="uk-alert-close" uk-close></a>
                                <p>{{ $errors->first('rules') }}</p>
                            </div>
                        @endif

                        <div class="uk-flex uk-flex-center">
                            <h2 class="uk-text-center uk-margin-small-bottom domain-registration"> خرید سامانه</h2>
                        </div>

                        <ul uk-accordion>
                            <li class="card">
                                <a class="uk-accordion-title">{{$platform->name}}</a>
                                <div class="uk-text-center">
                                    <input class="uk-input uk-input-num" placeholder="1" disabled >
                                </div>
                                <div class="uk-float-left">
                                    <span class="price">{{number_format($platform->price)}}</span> <span class="price">ریال</span>
                                </div>
                                <div class="uk-accordion-content">
                                    <ul class="uk-margin-medium-top">
                                        @if(!session()->get('HASDOMAIN'))
                                        <li> <span>دامنه</span> {{$suffix}} <span class="uk-float-left price">{{$domain->price !=0 ? number_format($domain->price) . ' تومان' : 'رایگان'}}</span> </li>
                                        @endif
                                        <li> <span>میزبانی</span> <span class="uk-float-left price"> رایگان</span></li>
                                        <li>{{$sms->name}}<span class="uk-float-left price"> رایگان</span></li>
                                    </ul>
                                </div>
                            </li>
                        </ul>
                        <div class="uk-flex uk-flex-between uk-position-relative" id="invoice">
                            <div class="detail-buy uk-margin-small-left">
                                <ul>
                                    <li>
                                        <div class="uk-float-left">
                                            <span id="basket_price" class="uk-float-left">{{number_format($total_price)}}</span>
                                            <span class="uk-margin-small-left">ریال</span>
                                        </div>
                                        <div>
                                            <span>مجموع سبد خرید</span><br>
                                        </div>
                                    </li>
                                    <li class="border-bottom">
                                        <div class="uk-float-left">
                                            @php($tax = (int)( (( (int)$platform->tax )*$platform->price)/100))
                                            <span id="basket_price" class="uk-float-left">{{number_format($tax)}}</span>
                                            <span class="uk-margin-small-left">ریال</span>
                                        </div>
                                        <div>
                                            <span> مالیات ارزش افزوده</span><br>
                                        </div>
                                    </li>
                                    <li class=" uk-margin-medium-top">
                                        <div class="uk-float-left">
                                            <span id="payable" class="uk-float-left">{{number_format($total_price + $tax)}}</span>
                                            <span class="uk-margin-small-left">ریال</span>
                                        </div>
                                        <div>
                                            <span>خالص پرداختی</span><br>
                                        </div>
                                    </li>
                                    <li>
                                        <div class="uk-float-left">
                                            <span id="total-discount" class="uk-float-left">0</span>
                                            <span class="uk-margin-small-left">ریال</span>
                                        </div>
                                        <div>
                                            <span>تخفیف</span><br>
                                        </div>
                                    </li>
         
                                    
                                    <li class="uk-margin-medium-top">
                                        <div  class="uk-float-left">
                                            <span id="total_price" class="uk-float-left" style="font-size: 16px; font-weight: 500">{{number_format($total_price + $tax)}}</span>
                                            <span class="uk-margin-small-left">ریال</span>
                                        </div>
                                        <div>
                                            <span style="font-size: 16px; font-weight: 500">قابل پرداخت</span>
                                        </div>
                                    </li>
                                </ul>
                            </div>
                            <div class="addition-subtraction uk-flex uk-flex-column">
                                <span class="addition">+</span>
                                <span class="subtraction">-</span>
                            </div>
                        </div>
                        <input type="hidden" name="total_price" value="{{$total_price + $tax}}">

                        <form action="{{route('home_save_basket')}}" method="POST">
                        <ul class="uk-margin-top" uk-accordion>
                            <li class="card uk-open">
                                <a class="uk-accordion-title">کد تخفیف دارید؟</a>
                                <div class="uk-accordion-content">
                                    <br>
                                    <div>
                                        @csrf
                                        <div class="uk-flex uk-flex-between">
                                            <div class="uk-margin-small-right">
                                                <span class="provide-discount-code">-</span>
                                                <input class="uk-input uk-input-discount" name="discount"  placeholder="کد تخفیف خود را وارد کنید.">
                                            </div>
                                            <div>
                                                <button type="submit" class="uk-button button-discount" id="check-discount">بررسی</button>
                                            </div>
                                        </div>

                                        <div class="uk-alert-danger uk-flex uk-flex-between uk-margin-small-top" style="display: none;">
                                            <span>زمان استفاده به پایان رسیده است.</span>
                                            <div class="expired-sign">!</div>
                                        </div>
                                        <div class="uk-alert-danger text-center" id="discount-failed" style="display: none;">کد تخفیف وارد شده نا معتبر است</div>
                                        <div class="uk-alert-success text-center" id="discount-success" style="display: none;">کد تخفیف با موفقیت اعمال شد</div>
                                    </div>
                                </div>
                            </li>
                        </ul>

                        <div class="uk-margin uk-grid-small uk-child-width-auto uk-grid uk-margin-small-right">
                            <label class="uk-margin-small-left"><input class="uk-radio" type="radio" name="gateway" value="1" checked>بانک تجارت</label>
                            <label class="uk-margin-small-left"><input class="uk-radio" type="radio" name="gateway" value="2">زرین پال</label>
                        </div>

                        <div class="uk-float-right uk-margin uk-grid-small uk-child-width-auto uk-grid">
                            <label class="rule"><input class="uk-checkbox" type="checkbox" name="rules" value="accept"> قوانین و مقررات را خوانده مورد تایید است</label>
                        </div>
                        <div>
                            <input type="hidden" name="total_price" value="{{$total_price + $tax}}">
                            <input type="hidden" name="csrf-token" value="{{ csrf_token() }}">
                            <input type="hidden" name="final_price" id="final_price" value="{{$total_price + $tax}}">
                        </div>
                        <div class="uk-flex uk-flex-between uk-margin-large-top btn-accept-cancel">
                            <a href="#"><button class="uk-button button-cancel-order">انصراف</button></a>
                            <a href="{{route('home_save_basket')}}" rel="nofollow"><button class="uk-button button-accept-order">پرداخت</button></a>
                            
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    

    <div id="loading" class="uk-flex-top" uk-modal>
        <div class="uk-modal-dialog uk-modal-body uk-margin-auto-vertical" style="width: 21rem">
            <div class="uk-text-center">
                <img src="{{asset('images/loading.gif')}}" alt="" width="100">
                <p class="uk-text-lead">لطفا صبر کنید !</p>
            </div>
        </div>
    </div>

    <script src="{{ asset('front/buy/js/jquery.js') }}"></script>
    <script src="{{ asset('front/buy/js/uikit-icons.min.js') }}"></script>
    <script src="{{ asset('front/buy/js/uikit.min.js') }}"></script>
    <script>
        $("#check-discount").click(function( event ) {
            event.preventDefault();
            var total_price  = parseInt($('input[name="total_price"]').val());
            var discount_code = $('input[name="discount"]').val();
            var token = $('input[name="_token"]').val();

            $.ajax({
  
            type: "GET",
            data: {discount_code:discount_code,_token:token},
            url: "{{route('home_discount')}}",
            
            success: function(response){
                if(response == -1){
                    $("#total-discount").text(0);
                    $("#total_price").text(total_price.toLocaleString());
                    $("#discount-success").hide();
                    $("#discount-failed").show();
                }else{
                    var discount_price = (total_price*response.percentage)/100;
                    $("#total-discount").text(discount_price.toLocaleString());
                    var priceWithDiscount = total_price - discount_price;
                    $("#total_price").text(priceWithDiscount.toLocaleString());  
                    $("#discount-success").show();
                    $("#discount-failed").hide();
                }
            }
            });
        });
        $(document).on({
            ajaxStart: function() { $('#loading').addClass("uk-flex uk-open");    },
            ajaxStop: function() { $('#loading').removeClass("uk-flex uk-open");  } ,  
        });
    </script>
@endsection




