@extends('layouts.yekita')

@section('content')
    <section id="slider">
        <div class="uk-position-relative uk-visible-toggle uk-light uk-slider uk-slider-container" tabindex="-1" uk-slider="center: true ; autoplay: true">

            <ul class="uk-slider-items uk-grid">
                <li class="uk-width-1-1">
                    <div class="uk-panel">
                        <img src="{{ asset('front/img/slider.jpg') }}" alt="">
                    </div>
                </li>
                <li class="uk-width-1-1">
                    <div class="uk-panel">
                        <img src="{{ asset('front/img/slider1.jpg') }}" alt="">
                    </div>
                </li>
                <li class="uk-width-1-1">
                    <div class="uk-panel">
                        <img src="{{ asset('front/img/slider2.jpg') }}" alt="">
                    </div>
                </li>
            </ul>
            <a class="uk-position-center-left uk-position-small uk-hidden-hover" href="#" uk-slidenav-next
               uk-slider-item="next"> <img src="{{ asset('front/img/left.svg') }}" alt=""></a>
            <a class="uk-position-center-right uk-position-small uk-hidden-hover" href="#" uk-slidenav-previous
               uk-slider-item="previous"> <img src="{{ asset('front/img/right.svg') }}" alt=""></a>
        </div>
    </section>
    <section id="section2" class="">
        <div class="uk-container">
            <div class="background-section2">
{{--                <div class="uk-grid">--}}
{{--                    <div class="uk-width-1-1 uk-text-center">--}}
{{--                        <i class="material-icons-arrow">--}}
{{--                            keyboard_arrow_down--}}
{{--                        </i>--}}
{{--                    </div>--}}
{{--                </div>--}}
                <div class="uk-grid" uk-grid>
                    <div class="uk-width-1-2@m uk-text-center">

                    <img class="" src="{{ asset('front/yekita/img/Group%20262.svg') }}" alt="">

                    </div>
                    <div class="uk-width-1-2@m">
                        <h4>ارایه وبسایت اختصاصی آموزش</h4>
                        <ul class="uk-light">
                            <li> <i class="material-icons-done">done</i> پشتیبانی از زبان مختلف </li>
                            <li><i class="material-icons-done">done</i> دامنه, میزبانی, پیامک و گوگل انالاتیک</li>
                            <li><i class="material-icons-done">done</i>ارایه محتوا در قالب بلاگ و خبر</li>
                            <li><i class="material-icons-done">done</i>قابلیت مدیریت با گوشی موبایل</li>
                            <li><i class="material-icons-done">done</i>ثبت دوره آموزشی و دریافت شهریه</li>
                            <li><i class="material-icons-done">done</i>پنل مدیریتی برای برگزار کننده, مدرس و شرکت کننده</li>
                            <li><i class="material-icons-done">done</i> مدیریت; ثبت نام و پرداخت انلاین ئدرسان جلسات محل برگزاری امور مالی و ....</li>
                        </ul>

                        <div class="position-left uk-visible@s">
                            <i class="material-icons-star">
                                star
                            </i>
                            <i class="label">محافطت از فایل ارزشمند شما</i>
                            <i class="material-icons">
                                phone_iphone
                            </i>
                            <i class="material-icons">
                                web
                            </i>
                        </div>
                        <ul uk-accordion>
                            <li>
                                <a class="uk-accordion-title" href="#">اطلاعات بیشتر</a>
                                <div class="uk-accordion-content">
                                    <p class="uk-margin-medium-top more">
                                        یکیتا به هر برگزارکننده یک وب سایت اختصاصی آموزش چند زبانه با تمامی موارد لازم برای شروع کار و دامنه اختصاصی ارائه می نماید. مدیریت محتوای این وب سایت توسط برگزارکننده و از طریق ناحیه کاربری قابل انجام است. برگزارکننده می تواند محتوای اختصاصی خود را مانند؛ لوگو، اسلایدر، وبلاگ، درباره ما و تماس با ما در سایت خود داشته باشد.

                                        برگزارکننده پس از انجام پیکربندی و تنظیمات، دوره های آموزشی مورد نظر را در ناحیه کاربری ایجاد می نماید. مراجعه کنندگان به وب سایت، پس از اطلاع از مشخصات دوره ها، می توانند به صورت آنلاین در دوره ها ثبت نام و وجوه ثبت نام را واریز نموده و در دوره ها شرکت نمایند.

                                        برخی از امکانات وب سایت: مدیریت؛ ثبت نام و پرداخت آنلاین، مدرسان، محل برگزاری، جلسات، دوره ها، کارت شناسایی و ورود، جزوات آموزشی، حضور و غیاب، مالی و تخفیفات، شرکت کنندگان، ارتباطات و گواهی پایان دوره
                                    </p>
                                </div>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <section id="section3">
        <div class="uk-container">
            <div class="background-section3">
                <div class="uk-grid" uk-grid>
                    <div class="uk-width-1-2@m">
                        <h4>اپلیکیشن مرجع دوره های آموزشی</h4>
                        <ul class="uk-light">
                            <li><i class="material-icons-done">done</i>معرفی و اطلاع رسانی دوره های آموزشی در کل کشور</li>
                            <li><i class="material-icons-done">done</i>جست و جو فیلتر ئرخواست دوره ارایه مشخصات کامل دوره مشخصات برگزار کننده مشخصات مدرس ثبت نام انلاین دریافت جزوات آموزشی امتیاز دهی و ارسال نظر</li>
                        </ul>
                        <ul>
                            <li><a href="/fa/download"><button class="uk-button uk-button-application"><i class="material-icons uk-float-right">arrow_downward</i>دانلود اپلیکیشن</button></a></li>
                        </ul>
                        <div class="position-left uk-visible@s">
                            <i class="material-icons-star">
                                star
                            </i>
                            <i class="label">محافطت از فایل ارزشمند شما</i>
                        </div>
                        <ul uk-accordion>
                            <li>
                                <a class="uk-accordion-title" href="#">اطلاعات بیشتر</a>
                                <div class="uk-accordion-content">
                                    <p class="uk-margin-medium-top more">
                                        تمام دوره هایی که برگزار کنندگان در وب سایت خود ثبت نموده اند، در وب سایت مرکزی و اپلیکیشن یکیتا به صورت خودکار و پس از بررسی محتوا توسط کارشناسان یکیتا، برای کاربران نمایش داده خواهند شد. به دلیل تجمیع همه دوره ها در اپلیکیشن یکیتا، محل مناسبی برای دیده شدن دوره ها و جذب بالای مخاطبان است.

                                        امکانات اپلیکیشن: طراحی شده برای سیستم عامل های اندروید و آیفون، چند زبانه، جستجو و فیلترینگ پیشرفته، جستجو در نقشه، درخواست دوره، ارائه مشخصات کامل دوره، برگزارکننده و مدرس، ارتباط با مدرس، ثبت نام و پرداخت هزینه آنلاین، دریافت محتوای آموزشی، امتیازدهی به دوره ها و مدرسان، ارسال نظر در مورد دوره ها، لیست علاقه مندی ها و شرکت در دوره های غیرحضوری آنلاین (زنده).
                                    </p>
                                </div>
                            </li>
                        </ul>
                    </div>
                    <div class="uk-width-1-2@m uk-text-center">
                        <img class=""  src="{{ asset('front/yekita/img/Group%20713.svg') }}" alt="">
                    </div>
                </div>
            </div>
        </div>
    </section>
    <section id="section4">
        <div class="uk-container">
            <div class="background-section2">
                <div class="uk-grid" uk-grid>
                    <div class="uk-width-1-2@m uk-text-center">
                        <img class=""  src="{{ asset('front/yekita/img/Group%20460.svg') }}" alt="">
                    </div>
                    <div class="uk-width-1-2@m">
                        <h4>آموزش مجازی انلاین</h4>
                        <ul class="uk-light">
                            <li><i class="material-icons-done">done</i> تعامل دو سویه از طریق آموزش مجازی</li>
                            <li><i class="material-icons-done">done</i>بدون محدودیت جغرافیایی</li>
                            <li><i class="material-icons-done">done</i>ارایه در بستر های دسکتاپ و موبایل</li>
                            <li><i class="material-icons-done">done</i>نمایش تصویر زنده مدرس و شرکت کننده</li>
                            <li><i class="material-icons-done">done</i>امکان اشتراک گذاری صفحه دسکتاپ</li>
                            <li><i class="material-icons-done">done</i>گفت وگوی انلاین</li>
                            <li><i class="material-icons-done">done</i>اشتراک گذاری فایل</li>
                        </ul>
                        <img src="{{ asset('front/yekita/img/Group%20470.svg') }}" class="live uk-animation-reverse uk-transform-origin-top-right" alt="live" uk-scrollspy="cls: uk-animation-kenburns; repeat: true">
                        <ul uk-accordion>
                            <li>
                                <a class="uk-accordion-title" href="#">اطلاعات بیشتر</a>
                                <div class="uk-accordion-content">
                                    <p class="uk-margin-medium-top more">
                                        یکی از امکانات جذاب و کاربردی یکیتا ارائه ی محتوای آموزشی در اپلیکیشن یکیتا و محافظت از آن ها در مقابل کپی و اشتراک گذاری غیر مجاز. برگزارکننده می تواند بدون نگرانی، محتوای آموزشی خود را در قالب؛ فیلم، صدا، تصویر و متن ارائه و به فروش برساند. برگزارکننده می تواند محتوای آموزشی خود را به 2 صورت ارائه نماید؛ 1- به صورت محافظت شده و ارائه فقط در اپلیکیشن های موبایل 2- قابل نمایش و دانلود در وب سایت. بنابراین فقط کسانی می توانند محتوا را دریافت کنند که هزینه آن را پرداخت نموده اند. این امکان فوق العاده می تواند درآمد تولید و عرضه کنندگان محتوا را به شکل قابل توجهی افزایش دهد.
                                    </p>
                                </div>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <section id="section5">
        <div class="uk-container">
            <div class="background-section5">
                <div class="uk-grid" uk-grid>
                    <div class="uk-width-1-2@m">
                        <h4>فروش محتوای غیر قابل انتشار</h4>
                        <ul class="uk-light">
                            <li><i class="material-icons-done">done</i>محتوای آموزشی در اپلیکیشن یکیتا در برابر کپی و اشتراک گذاری محافظت می شود</li>
                            <li><i class="material-icons-done">done</i>محتوای آموزشی در قالب فیلم صدا فایل</li>
                            <li><i class="material-icons-done">done</i>کسب درامد از فروش محتوای آموزشی</li>
                        </ul>
                        <div class="uk-float-left uk-visible@s">
                            <i class="material-icons-star">
                                star
                            </i>
                            <i class="label">محافطت از فایل ارزشمند شما</i>
                            <i class="material-icons">
                                movie
                            </i>
                            <i class="material-icons">
                                volume_up
                            </i>
                            <i class="material-icons">
                                photo
                            </i>
                            <i class="material-icons">
                                picture_as_pdf
                            </i>
                        </div>
                        <ul uk-accordion>
                            <li>
                                <a class="uk-accordion-title" href="#">اطلاعات بیشتر</a>
                                <div class="uk-accordion-content">
                                    <p>

                                    </p>
                                </div>
                            </li>
                        </ul>
                    </div>
                    <div class="uk-width-1-2@m uk-text-center">
                        <div class="uk-overflow-hidden">
                            <img src="{{ asset('front/yekita/img/Group%20660.svg') }}" alt="coins">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <section id="section6">
        <div class="uk-container">
            <div class="background-section6">
                <div class="uk-grid" uk-grid>
                    <div class="uk-width-1-2@m uk-text-center">
                        <img class="" src="{{ asset('front/yekita/img/Group%20677.svg') }}" alt="">
                    </div>
                    <div class="uk-width-1-2@m">
                        <h4>تقویم آموزشی</h4>
                        <ul class="uk-light">
                            <li><i class="material-icons-done">done</i>تقویم شمسی و میلادی</li>
                            <li><i class="material-icons-done">done</i>مدیریت زمان بندی فعالیت آموزشی</li>
                            <li><i class="material-icons-done">done</i>تقویم اختصاصی کاربران</li>
                            <li><i class="material-icons-done">done</i>تعریف سطح دسترسی</li>
                            <li><i class="material-icons-done">done</i>اشتراک گذاری رویدادها</li>
                        </ul>
                        <div class="position-left uk-visible@s">
                            <i class="material-icons-star">
                                star
                            </i>
                            <i class="label">محافطت از فایل ارزشمند شما</i>
                        </div>
                        <ul uk-accordion>
                            <li>
                                <a class="uk-accordion-title" href="#">اطلاعات بیشتر</a>
                                <div class="uk-accordion-content">
                                    <p class="uk-margin-medium-top more">
                                        تقویم شمسی و میلادی یکیتا امکان مدیریت زمان بندی فعالیت های آموزشی به شما می دهد. همه اعضای یکیتا دارای تقویم کاری خود هستند و می توانند بر اساس سطح دسترسی تعریف شده انواع مختلف رویدادها را ببینند، ثبت و ویرایش کنند و با دیگران به اشتراک بگذارند.
                                    </p>
                                </div>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <section id="blog">
        <div class="uk-container">
            <div class="background-section5">
                <div class="container">
                    <div class="uk-width-1-1 uk-text-center uk-margin-medium-bottom">
                        <label>اخبار و بلاگ</label>
                    </div>
                    <div class="uk-grid">
                        @foreach($blog as $value)
                            <div class="uk-width-1-4@xl uk-width-1-4@l uk-width-1-3@m uk-width-1-2@s blog-grid uk-margin-small-top">
                                <a href="/content/{{$value->id}}/{{App::getLocale()}}" rel="nofollow">
                                    <div class="uk-card uk-card-default">
                                        <div class="uk-card-media-top">
                                            <img src="{{asset('images/article/thumbs/380/'.$value->image)}}" alt="{{$value->title}}">
                                        </div>
                                        <div class="uk-card-body">
                                            <h4 class="uk-card-title blogtitle">{{$value->title}}</h4>
                                            <p class="blog-description blogdescription">{{$value->description}}</p>
                                        </div>
                                    </div>
                                </a>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </section>
    <section id="section7">
        <div class="uk-container">
            <div class="background-section7">
                <div class="uk-grid" uk-grid>
                    <div class="uk-width-1-1 uk-text-center">
                        <div class="divider uk-margin-small-bottom">
                            <span>مجوز ها </span>
                        </div>
                        <img src="{{ asset('front/yekita/img/mojavez/Rectangle%20537.png') }}" alt="license">
                        <img src="{{ asset('front/yekita/img/mojavez/Rectangle%20538.png') }}" alt="license">
                        <img src="{{ asset('front/yekita/img/mojavez/Rectangle%20539.png') }}" alt="license">
                        <img class="samandehi" id='jxlzesgtjxlzoeukwlaowlaoapfu' style='cursor:pointer' onclick='window.open("https://logo.samandehi.ir/Verify.aspx?id=1018445&p=rfthobpdrfthmcsiaodsaodsdshw", "Popup","toolbar=no, scrollbars=no, location=no, statusbar=no, menubar=no, resizable=0, width=450, height=630, top=30")' alt='logo-samandehi' src="{{ asset('front/yekita/img/mojavez/Rectangle%20541.png') }}"/>
                        <img src="{{ asset('front/yekita/img/mojavez/Rectangle%20542.png') }}" alt="license">
                        <img src="{{ asset('front/yekita/img/mojavez/Rectangle%20543.png') }}" alt="license">
                        <a href="http://services.irannsr.org/index.php?module=cdk&func=loadmodule&system=cdk&sismodule=user/content_view.php&sisOp=view&cnt_id=262854&ctp_id=70&id=850&template=public_front_end_profile" target="_blank"><img src="{{ asset('front/yekita/img/mojavez/Group%20716.png') }}" alt="license"></a>
                        <img class="enamad"  src="{{ asset('front/yekita/img/mojavez/Group%20719.png') }}" alt="" onclick="window.open(&quot;https://trustseal.enamad.ir/Verify.aspx?id=110782&amp;p=BfvRWJoXiy6yOxvv&quot;, &quot;Popup&quot;,&quot;toolbar=no, location=no, statusbar=no, menubar=no, scrollbars=1, resizable=0, width=580, height=600, top=30&quot;)" style="cursor:pointer" id="BfvRWJoXiy6yOxvv">
                    </div>
                    <div class="uk-width-1-1 uk-text-center uk-margin-small-top bank">
                        <div class="divider uk-margin-small-bottom">
                            <span>موسسات مالی اعتباری</span>
                        </div>
                        <img src="{{ asset('front/yekita/img/bank/Group%20751.png') }}" alt="bank">
                        <img src="{{ asset('front/yekita/img/bank/Group%202468.png') }}" alt="bank">
                        <img src="{{ asset('front/yekita/img/bank/Group%202469.png') }}" alt="bank">
                        <img src="{{ asset('front/yekita/img/bank/Group%202474.png')}}" alt="bank">
                        <img src="{{ asset('front/yekita/img/bank/Group%202475.png') }}" alt="bank">
                        <img src="{{ asset('front/yekita/img/bank/Group%202476.png') }}" alt="bank">
                        <img src="{{ asset('front/yekita/img/bank/Group%202477.png') }}" alt="bank">
                        <img src="{{ asset('front/yekita/img/bank/Group%202478.png') }}" alt="bank">
                        <img src="{{ asset('front/yekita/img/bank/Group%202479.png') }}" alt="bank">
                        <img src="{{ asset('front/yekita/img/bank/Path%203231.png') }}" alt="bank">
                        <img src="{{ asset('front/yekita/img/bank/Path%204123.png') }}" alt="bank">
                    </div>
                    <div class="uk-width-1-1 uk-text-center uk-margin-small-top">
                        <div class="divider uk-margin-small-bottom">
                            <span>همکاران</span>
                        </div>
                        <img src="{{ asset('front/yekita/img/hamkaran/Group%202483.png') }}" alt="bank">
                        <img src="{{ asset('front/yekita/img/hamkaran/Group%202484.png') }}" alt="bank">
                        <img src="{{ asset('front/yekita/img/hamkaran/Group%202487.png') }}" alt="bank">
                        <img src="{{ asset('front/yekita/img/hamkaran/Group%202489.png') }}" alt="bank">
                        <img src="{{ asset('front/yekita/img/hamkaran/Group%202490.png') }}" alt="bank">
                        <img src="{{ asset('front/yekita/img/hamkaran/Group%202491.png') }}" alt="bank">
                    </div>
                </div>
            </div>
        </div>
    </section>

@endsection

@section('footer')
    <script type="text/javascript">
        jQuery(function() {
            var minimized_title = $('.blogtitle');
            minimized_title.each(function() {
                var t = $(this).text();
                if (t.length < 15) return;
                $(this).html(t.slice(0, 15) + '<span>... </span>' + '<span class="hide">' + t.slice(15, t.length) + '</span>')
            })
            var minimized_title = $('.blogdescription');
            minimized_title.each(function() {
                var t = $(this).text();
                if (t.length < 90) return;
                $(this).html(t.slice(0, 90) + '<span>... </span>' + '<span class="hide">' + t.slice(90, t.length) + '</span>')
            })
        });
        //
        // function isInView(el) {
        //     var rect = el.getBoundingClientRect();           // absolute position of video element
        //     return !(rect.top > $(window).height() || rect.bottom < 0);   // visible?
        // }
    </script>
@endsection
