@extends('layouts.dashboard')

@section('header')

@endsection

@section('content')
    <div class="row border-bottom">
        <div class="col-xs-12 col-md-6">
            <span>شماره صورت حساب : </span><span>{{$id}}</span>
        </div>
        <div class="col-xs-12 col-md-6">
            <span>تاریخ صورت حساب : </span><span>{{$create_date}}</span>
        </div>
    </div>
    <div class="row row-padding">
        <div class="col-xs-12 col-md-6">
            <p><span>نام فروشنده :  </span><span class="padding-span">سبا قدحی</span><br></p>
            <p><span>تلفن :  </span><span class="padding-span">09371037042</span><br></p>
            <p><span>نشانی :  </span><span class="padding-span">تهران ونک</span></p>
        </div>
        <div class="col-xs-12 col-md-6">
            <p><span>نام خریدار :  </span><span class="padding-span">{{$user_info->name.' '.$user_info->lastname}}</span><br></p>
            <p><span>تلفن :  </span><span class="padding-span">{{$user_info->mobile_number}}</span><br></p>
            <p><span>نشانی :  </span><span class="padding-span"></span></p>
        </div>
    </div>
    <div class="row row-padding">
        <div class="col-xs-12">
            <table class="table">
                <thead>
                <tr>
                    <th>ردیف</th>
                    <th>عنوان</th>
                    <th>تعداد مجوز / اعتبار</th>
                    <th>مبلغ</th>
                </tr>
                </thead>
                <tbody>
                @foreach($basket as $value)
                    <tr>
                        <td>{{$loop->iteration}}</td>
                        <td>{{\App\Http\pars_attributes($value->attributes)['order.base.product.name']}}</td>
                        <td><strong>{{\App\Http\pars_attributes($value->attributes)['order.base.product.quantity']}}</strong></td>
                        @if(is_null($value->discount))
                            <td><strong>-</strong></td>
                            <td><span>{{\App\Http\pars_attributes($value->attributes)['order.base.product.price']}}</span> <a href="{{route('dash_delete_product',$value->id)}}"><button class="delete-table">حذف</button></a></td>
                        @else
                            <td><strong><a href="{{route('dash_discount_delete' , 'public')}}">del</a>123456</strong></td>
                            <td><span>{{\App\Http\pars_attributes($value->attributes)['order.base.product.price'] + \App\Http\pars_attributes($value->discount)['order.base.product.price']  }}</span> <a href="{{route('dash_delete_product',$value->id)}}"><button class="delete-table">حذف</button></a></td>
                        @endif
                    </tr>
                @endforeach
                </tbody>
            </table>
        </div>
    </div>
    <div class="row margin-top">
        <div class="col-xs-12 col-md-6"></div>
        <div class="col-xs-12 col-md-6">
            <p><span>مبلغ قابل پرداخت  :  </span><span class="padding-span">145000</span><br></p>
            <p><span>مبلغ تخفیف :  </span><span class="padding-span">0</span><br></p>
            <p><span>حساب کیف پول :  </span><span class="padding-span">0</span></p>
            <p><span>مبلغ قابل پرداخت (با 9 درصد مالیت بر ارزش افزوده) :  </span><span class="padding-span">158000</span></p>
            <button class="button-print" onclick="myFunction()">چاپ</button>
            <a href="{{route('dash_pay' , $id)}}"><button class="button-pay" >پرداخت</button></a>
        </div>
    </div>
@endsection

@section('footer')

@endsection