@extends('layouts.dashboard')

@section('header')

@endsection

@section('content')
    @isset($error)

        @else

            <div class="row border-padding">
                <div class="col-xs-12 col-md-6">
                    <h4 class="shop-h4"> سامانه مدیریت دوره و کارگاه آموزشی یکیتا</h4>
                </div>
                <div class="col-xs-12 col-md-6 price-col">
                    <span>مبلغ قابل پرداخت :  </span><span class="price-color">{{$amount}} ریال</span><br>
                    <a href="{{route('dash_cart')}}">
                        مشاهده سبد خرید
                    </a>
                </div>
            </div>

            <div class="row margin-top-row">

                <form method="post" action="{{route('dash_add_product')}}">
                    @csrf
                    <input name="product" value="{{$product[config('global.SKU_YEKITA')]['pid']}}" type="hidden">
                    <div class="col-md-4 col-sm-6 col-xs-12 li-user-avatar">
                        <div class="form-group" id="public">
                            <label for="exampleFormControlInput1">اعتبار عمومی</label>
                            <i class="fas fa-plus icon-plus-mines mines plus-btn"></i><input data-value="{{$product[config('global.SKU_YEKITA')]['price']}}" min="0" type="number" class="form-control input-shop credit-course" id="public" placeholder="" value="1"><i class="fas fa-minus icon-plus-mines icon-plus-mines plus mines-btn"></i>
                        </div>
                    </div>
                    <div class="col-md-4 col-sm-6 col-xs-12 li-user-avatar">
                        <div class="form-group" id="half-private">
                            <label for="exampleFormControlInput1">اعتبار نیمه خصوصی</label>
                            <i class="fas fa-plus icon-plus-mines mines plus-btn"></i><input data-value="{{$product[config('global.SKU_YEKITA')]['price']}}" min="0" type="number" class="form-control input-shop credit-course" id="private" placeholder="" value="0"><i class="fas fa-minus icon-plus-mines icon-plus-mines plus mines-btn"></i>
                        </div>
                    </div>
                    <div class="col-md-4 col-sm-6 col-xs-12 li-user-avatar">
                        <div class="form-group" id="private">
                            <label for="exampleFormControlInput1">اعتبار خصوصی</label>
                            <i class="fas fa-plus icon-plus-mines mines plus-btn"></i><input data-value="{{$product[config('global.SKU_YEKITA')]['price']}}" min="0" type="number" class="form-control input-shop credit-course" id="half-private" placeholder="" value="0"><i class="fas fa-minus icon-plus-mines icon-plus-mines plus mines-btn"></i>
                        </div>
                    </div>
                    <div class="col-md-4 col-sm-6 col-xs-12 li-user-avatar">
                        <div class="form-group">
                            <label for="exampleFormControlSelect1">پسوند دامنه</label>
                            <select name="SUFFIX" class="form-control select-host-padding">
                                @foreach($product as $value)
                                    @if($value['type'] == config('global.SKU_SUFFIXDOMAIN'))
                                        <option value="{{$value['code']}}">{{$value['code']}}</option>
                                    @endif
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-md-4 col-sm-6 col-xs-12 li-user-avatar">
                        <div class="form-group">
                            <label for="exampleFormControlSelect1">میزبانی سرور</label>
                            <select data-value="{{$product['PACKAGE_A']['price']}}" name="HOSTING" class="form-control select-host-padding" id="form-host-select">
                                @foreach($product as $value)
                                    @if($value['type'] == 'HOSTING')
                                        <option value="{{$value['code']}}">{{$value['name']}}</option>
                                    @endif
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-md-4 col-sm-6 col-xs-12 li-user-avatar">
                        <div class="form-group">
                            <label for="exampleFormControlSelect1">انتخاب بسته پیامکی</label>
                            <select data-value="{{$product['SMS']['price']}}" name="SMS" class="form-control select-sms-padding sms-item" id="form-sms-select">
                                <option value="500">بسته پیامک 500</option>
                                <option value="1000">بسته پیامکی 1000</option>
                                <option value="1500">بسته پیامکی 1500</option>
                                <option value="2000">بسته پیامکی 2000</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-4 col-sm-6 col-xs-12 li-user-avatar">
                        <div class="form-group">
                            <div class="row">
                                <div class="col-xs-12">
                                    <button type="submit" class="button-pay  float-left"> افزودن به سبد </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
    @endisset
@endsection
@section('footer')
    <script>
        function update_price() {
            var public       = parseInt($('#public').val()) * parseInt($('#public').attr('data-value'));
            var private      = parseInt($('#private').val()) * parseInt($('#private').attr('data-value'));
            var half_private = parseInt($('#half-private').val()) * parseInt($('#half-private').attr('data-value'));
            console.log(half_private);
            //var sms          = parseInt($('#form-sms-select').val()) * parseInt($('#form-sms-select').attr('data-value'));
            //var package      = parseInt($('#form-host-select').attr('data-value'));
            //var new_price    = parseInt(yekita_price) + parseInt(suffix_price) + parseInt(public) + parseInt(private) + parseInt(half_private) + parseInt(sms) + parseInt(package);
            {{--$.ajax({--}}
                {{--url: "{{route('home_number_format')}}",--}}
                {{--type: 'POST',--}}
                {{--data: {new_price:new_price},--}}
                {{--dataType: 'JSON',--}}
                {{--success: function (data) {--}}
                    {{--$('#basket_price').html(data.price);--}}
                {{--}--}}
            {{--});--}}
        }
        $('.credit-course').change(function () {
            var num = parseInt($('#public').val()) + parseInt($('#private').val()) + parseInt($('#half-private').val());
            if(num < 1){
                $(this).val(1);
            }
            update_price();
        });
    </script>
@endsection