@extends('layouts.dashboard')

@section('header')

@endsection


@section('content')
        <div class="row border-bottom">
            <div class="col-xs-12 col-md-6">
                <span>سبد خرید</span>
            </div>
            <div class="col-xs-12 col-md-6 text-left">
                <span>برای ثبت سفارش باید مراحل زیر را تکمیل کنید.</span>
            </div>
        </div>
        <div class="row margin-top border-bottom">
            <div class="table-responsive">
                <table class="table">
                    <thead>
                    <tr>
                        <th>ردیف</th>
                        <th>عنوان</th>
                        <th>مشخصات سیستم</th>
                        <th>قیمت</th>
                    </tr>
                    </thead>
                    <tbody>
                    @foreach($product as $value)
                            <tr>
                                <td>{{$loop->iteration}}</td>
                                <td>{{$value['name']}}</td>
                                <td>
                                    <small>
@php
    $pubCredit = $priCredit = $hpriCredit = 0;
@endphp
@foreach($value['details'] as $attr)
        @switch(\App\Http\pars_attributes($attr)['order.base.product.attribute.code'])
            @case(config('global.SKU_PREFIXDOMAIN'))
                @php
                    $prefix = \App\Http\pars_attributes($attr)['order.base.product.attribute.value']
                @endphp
            @break
                @case(config('global.SKU_SUFFIXDOMAIN'))
                @php
                    $suffix = \App\Http\pars_attributes($attr)['order.base.product.attribute.name']
                @endphp
            @break
            @case(config('global.SKU_HASDOMAIN'))
                @if(\App\Http\pars_attributes($attr)['order.base.product.attribute.value'])
                    @php
                        $hasDomain = true
                    @endphp
                @else
                    @php
                        $hasDomain = false
                    @endphp
                @endif
            @break
            @case(config('global.SKU_HOSTING'))
                @php
                   $typeOfHost =  \App\Http\pars_attributes($attr)['order.base.product.attribute.value']
                @endphp
            @break
            @case(config('global.SKU_PUBCREDIT'))
                @php
                    $pubCredit = \App\Http\pars_attributes($attr)['order.base.product.attribute.quantity']
                @endphp
            @break
            @case(config('global.SKU_PRICREDIT'))
            @php
                $priCredit = \App\Http\pars_attributes($attr)['order.base.product.attribute.quantity']
            @endphp
            @break
            @case(config('global.SKU_HAFPRICREDIT'))
            @php
                $hpriCredit = \App\Http\pars_attributes($attr)['order.base.product.attribute.quantity']
            @endphp
            @break
            @case(config('global.SKU_SMS'))
                @php
                    $numberOfSMS = \App\Http\pars_attributes($attr)['order.base.product.attribute.quantity']
                @endphp
            @break
        @endswitch
    @endforeach
    @if($hasDomain)
        <span>دامنه دارد</span><br/>
    @else
        <span> دامنه ندارد</span><br/>
    @endif
    <span>پسوند دامنه:</span><span>{{$suffix}}</span><br/>
    <span>هاست انتخابی:</span><span>{{$typeOfHost}}</span><br/>
    <span>تعداد پیامک قابل ارسال:</span><span>{{$numberOfSMS}}</span><br/>
    <span>تعداد مجوز عمومی:</span><span>{{$pubCredit}}</span><br/>
    <span>تعداد مجوز خصوصی:</span><span>{{$priCredit}}</span><br/>
    <span>تعداد مجوز نیمه خصوصی:</span><span>{{$hpriCredit}}</span><br/>
                                    </small>
                                </td>
                                <td><span>{{$value['price']}}</span> <a href="{{route('dash_delete_product' , $value['basket_id'])}}"><button class="delete-table">حذف</button></a></td>
                            </tr>
                    @endforeach
                    <tr>
                        <td colspan="5"><span>جمع کل خرید شما : </span><span>{{$basket_price}}</span></td>
                    </tr>
                    </tbody>
                </table>
                <form action="{{route('dash_discount')}}" method="post">
                    @csrf
                    <input type="text" class="discount-shop-input" id="exampleFormControlInput4" placeholder="کد تخفیف خود را وارد کنید" >
                    <button class="discount-shop-button"> اعمال کد تخفیف </button>
                </form>
            </div>
        </div>
        <div class="row text-left">
            <a href="{{route('dash_shop')}}"><button class="button-print">صفحه محصولات</button></a>
            <a href="{{route('dash_save_basket')}}"><button class="button-pay" >تکمیل سفارش</button></a>
        </div>
    </div>

@endsection