@extends('layouts.dashboard')

@section('header')
    <link rel="stylesheet" href="https://unpkg.com/persian-datepicker@1.1.3/dist/css/persian-datepicker.css"/>
@endsection

@section('content')

    <div class="card">
        <form action="{{route('dash_update_user')}}" method="post">
            @csrf
            <div class="row">
                <div class="col-xs-12 text-center">
                    <div class="uk-width-1-1" id="Div-image">
                        @if ($errors->has('avatar'))
                            <span class="invalid-feedback md-text-danger" role="alert">
                                <small>{{ $errors->first('avatar') }}</small>
                            </span>
                        @endif
                        <button type="button" class=" remove_photo_croper button-close-crop">&times;</button>
                        <div id="upload-demo" class="max-width-220"></div>
                        <input type="hidden" id="image-code" name="avatar">
                        <input class="Upload_Croper" type="file" id="upload-image" data-parsley-id="7">
                        <div class="clearfix"><br></div>
                    </div>
                </div>
            </div>
            <div class="col-xs-12">
                @if ($errors->has('name'))
                    <span class="invalid-feedback md-text-danger" role="alert">
                        <small>{{ $errors->first('name') }}</small>
                    </span>
                @endif
                <label>{{__('profile.Name')}}</label><br>
                @if(!is_null(old('name')))
                    <input type="text" name="name" class="input-profile" value="{{old('name')}}" autocomplete="off">
                @else
                    <input type="text" name="name" class="input-profile" value="{{$user_info->name}}" autocomplete="off">
                @endif
                <br/>
            </div>
            <div class="col-xs-12">
                @if ($errors->has('lastname'))
                    <span class="invalid-feedback md-text-danger" role="alert">
                        <small>{{ $errors->first('lastname') }}</small>
                    </span>
                @endif
                <label>{{__('profile.Last name')}}</label><br>
                @if (!is_null(old('lastname')))
                    <input type="text" name="lastname" class="input-profile" value="{{old('lastname')}}" autocomplete="off">
                @else
                    <input type="text" name="lastname" class="input-profile" value="{{$user_info->last_name}}" autocomplete="off">
                @endif
                <br/>
            </div>
            <div class="col-xs-12">
                @if ($errors->has('email'))
                    <span class="invalid-feedback md-text-danger" role="alert">
                        <small>{{ $errors->first('email') }}</small>
                    </span>
                @endif
                @if(session()->has('error'))
                    <span class="invalid-feedback md-text-danger" role="alert">
                        <small>{{ __('profile.'.session()->get('error')) }}</small>
                    </span>
                @endif
                <label>{{__('profile.Email')}}</label><br>
                @if (!is_null(old('email')))
                    <input type="text" name="email" class="input-profile" value="{{old('email')}}" autocomplete="off">
                @else
                    <input type="text" name="email" class="input-profile" value="{{$user_info->email }}" autocomplete="off">
                @endif
            </div>
            <div class="clearfix"></div>
            <div class="col-xs-12">
                @if ($errors->has('birthday'))
                    <span class="invalid-feedback md-text-danger" role="alert">
                        <small>{{ $errors->first('birthday') }}</small>
                    </span>
                @endif
                <label>{{__('profile.Birthday')}}</label><br>
                <input name="birthday" id="birthday" type="hidden" value="">
                <input name="birthday_view" type="text" class="input-profile observer-example" value="{{$user_info->birthday }}" id="initial-value-type-example" readonly autocomplete="off"/>
                <br/>
            </div>
            <div class="col-xs-12">
                @if ($errors->has('gender'))
                    <span class="invalid-feedback md-text-danger" role="alert">
                        <small>{{ $errors->first('gender') }}</small>
                    </span>
                @endif
                <label>{{__('profile.Gender')}}</label><br>
                <select name="gender" id='single' class="input-profile select-width">
                    <option value=""></option>
                    <option @if(old('gender') == 'male' || @$user_info->gender == 'male') selected @endif value="male">{{__('login.Male')}}</option>
                    <option @if(old('gender') == 'female' || @$user_info->gender == 'female') selected @endif value="female">{{__('login.Female')}}</option>
                </select>
            </div>
            <div class="col-xs-12 margin-top" style="text-align: center">
                <a href="">
                    <button class="button-register-form">{{__('profile.Submit')}}</button>
                </a>
            </div>
        </form>
    </div>

@endsection

@section('footer')
    <script src="{{ asset('dashboard/js/croppie.js') }}"></script>
    <script src="https://unpkg.com/persian-date@1.0.5/dist/persian-date.js"></script>
    <script src="https://unpkg.com/persian-datepicker@1.1.3/dist/js/persian-datepicker.js"></script>
    <script>
        @if (!is_null(old('birthday')))
            $('#birthday').val('{{old('birthday')}}');
            $('#initial-value-type-example').val('{{old('birthday_view')}}');
        @else
            $('#birthday').val('{{ $birth->timestamp }}');
            $('#initial-value-type-example').val('{{ $birth->date }}');
        @endif

        $('.cr-image').attr('src', '{{$user_info->avatar }}');
        console.log('{{$user_info->avatar }}');

        $(window).resize(function() {
            var path = $(this);
            var contW = path.width();
            if(contW >= 751){
                document.getElementsByClassName("sidebar-toggle")[0].style.right="200px";
            }else{
                document.getElementsByClassName("sidebar-toggle")[0].style.right="-200px";
            }
        });
        $(document).ready(function() {
            $('.dropdown').on('show.bs.dropdown', function(e){
                $(this).find('.dropdown-menu').first().stop(true, true).slideDown(300);
            });
            $('.dropdown').on('hide.bs.dropdown', function(e){
                $(this).find('.dropdown-menu').first().stop(true, true).slideUp(300);
            });
            $("#menu-toggle").click(function(e) {
                e.preventDefault();
                var elem = document.getElementById("sidebar-wrapper");
                right = window.getComputedStyle(elem,null).getPropertyValue("right");
                if(right == "200px"){
                    document.getElementsByClassName("sidebar-toggle")[0].style.right="-200px";
                }
                else if(right == "-200px"){
                    document.getElementsByClassName("sidebar-toggle")[0].style.right="200px";
                }
            });
        });

        //start image 1
        $uploadCrop = $('#upload-demo').croppie({
            enableExif: true,
            viewport: {
                width: 152,
                height: 152
            },
            boundary: {
                width: 150,
                height: 150,
                type: 'circle'
            }
        });

        $('#upload-image').on('change', function () {
            var Id = $(this).parent().attr('id');
            $('#'+Id+' .cr-viewport').css('background-image' , 'none');
            var reader = new FileReader();
            reader.onload = function (e) {
                $uploadCrop.croppie('bind', {
                    url: e.target.result
                }).then(function(){
                    GetCode();
                });
            }
            reader.readAsDataURL(this.files[0]);
        });


        $('.cr-viewport').click(function () {
            $('#upload-image').trigger('click');
        });

        $('.remove_photo_croper').on('click', function() {
            $('.cr-image').attr('src', '');
            $('#upload-image').val('');
            $('#image-code').val('delete');
            $('div.cr-overlay').attr('style' , '');
        });


        function GetCode() {
            $uploadCrop.croppie('result', {
                type: 'canvas',
                size: {
                    width: 150,
                    height: 150,
                    type: 'square'
                },
                format: "jpeg",
                quality: '0.7'
            }).then(function (resp) {
                $('#image-code').val(resp);
            });
        }

        $('.cr-overlay').mouseup(function () {
            GetCode();
        });

        $('.cr-overlay').bind('mousewheel', function(e){
            GetCode();
        });

        $('#initial-value-type-example').persianDatepicker({
            initialValue: false,
            format: 'YYYY/MM/DD',
            altField: '.observer-example-alt',
            @if($language != 'fa')
            calendarType: 'gregorian',
            @endif
            maxDate: new persianDate().add('month', 0).valueOf(),
            minDate: new persianDate().subtract('month', 1800).valueOf()
        });

        $(document).on('click', "table.table-days td", function() {
            var time = $(this).attr('data-unix');
            $('#birthday').val(time);
        });
        $('img.cr-image').attr('src' , '{{$user_info->avatar}}' );
    </script>
@endsection
