@extends('layouts.dashboard')

@section('header')
    <style>
        .loader {
            border: 10px solid #f3f3f3;
            border-radius: 50%;
            border-top: 10px solid blue;
            border-bottom: 10px solid blue;
            width: 80px;
            height: 80px;
            -webkit-animation: spin 2s linear infinite;
            animation: spin 2s linear infinite;
            margin-right: auto;
            margin-left: auto;
        }

        @-webkit-keyframes spin {
            0% { -webkit-transform: rotate(0deg); }
            100% { -webkit-transform: rotate(360deg); }
        }

        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
    </style>
@endsection
@section('content')
    @isset($error)

    @else
    <div class="row border-bottom">
        <div class="col-xs-12 col-md-6">
            <span>فعال سازی سامانه</span>
        </div>
        <div class="col-xs-12 col-md-6 text-left">
            <span>کد مجوز : </span><span>{{$license->code}}</span>
        </div>
    </div>
    <div class="row margin-top text-center">
        <p class="p-detail">اطلاعات زیر را با دقت وارد کنید پس از فعال سازی ویرایش امکان پذیر نیست. درصورتی که نیاز به مشاوره و راهنمایی دارید پیش از فعال سازی با پشتیبانی فنی تماس حاصل نمایید.</p>
    </div>
    <div class="row margin-top text-center">
        @if(is_null($license->domain))
            <p>نام دامنه خود را انتخاب کنید.</p>
            <span dir="ltr">
                <input type="text" id="domain" dir="ltr" class="input-domain" style="font-family: 'Arial'" placeholder="domain" autofocus>.ir
            </span>
            <br>
            <button id="postbutton" class="button-check">بررسی</button><br>
            <div class="loader hidden"></div>
            <p class="text-danger hidden alert-domain" id="invalid-domain">دامنه نامعتبر است</p>
            <p class="text-danger hidden alert-domain" id="unavailable-domain">این دامنه قبلا ثبت شده است</p>
            <p class="text-danger hidden alert-domain" id="null-domain">لطفا نام دامنه را وارد کنید</p>
            <p class="text-success hidden alert-domain" id="accept-domain">شما میتوانید این دامنه را ثبت کنید</p>
            <form action="{{route('dash_reg_license')}}" method="post">
                @csrf
                <input name="code" type="hidden" value="{{$license->code}}">
                <input name="domain" id="domain-input" type="hidden" value="">
                <button type="submit" id="submit-domain" class="button-active hidden" disabled>ثبت و فعال سازی</button>
            </form>
        @endif
    </div>
    @endisset
@endsection

@section('footer')
<script>
    var CSRF_TOKEN = "{{ csrf_token() }}";
    var URL = "{{route('dash_check_domain')}}";
    $("#postbutton").click(function(){
        var suffix = 'ir';
        var domain = $("#domain").val();
        $.ajax({
            url: URL,
            type: 'POST',
            data: {_token: CSRF_TOKEN, domain:domain , suffix:suffix},
            dataType: 'JSON',
            success: function (data) {
                if(data.status == 1){
                    $('.loader').removeClass('hidden');
                    $('.alert-domain').addClass('hidden');
                    $("#submit-domain").addClass('hidden');
                    setTimeout(function(){
                        $("#submit-domain").removeClass('hidden').removeAttr('disabled');
                        $('#domain-input').val(data.domain);
                        $('.loader').addClass('hidden');
                        $('#accept-domain').removeClass('hidden');
                    } , 500);
                }else if(data.status == 0){
                    $('.loader').removeClass('hidden');
                    $('.alert-domain').addClass('hidden');
                    $("#submit-domain").addClass('hidden');
                    $('#domain-input').val('');
                    setTimeout(function() {
                        $('.loader').addClass('hidden');
                        $('#unavailable-domain').removeClass('hidden');
                    } , 500);
                }else if(data.status == 3){
                    $('.loader').removeClass('hidden');
                    $('.alert-domain').addClass('hidden');
                    $("#submit-domain").addClass('hidden');
                    $('#domain-input').val('');
                    setTimeout(function() {
                        $('.loader').addClass('hidden');
                        $('#null-domain').removeClass('hidden');
                    } , 500);
                }else{
                    $('.loader').removeClass('hidden');
                    $('.alert-domain').addClass('hidden');
                    $("#submit-domain").addClass('hidden');
                    $('#domain-input').val('');
                    setTimeout(function() {
                        $('.loader').addClass('hidden');
                        $('#invalid-domain').removeClass('hidden');
                    } , 500);
                }
            }
        });
    });
</script>
@endsection