@extends('layouts.dashboard')

@section('header')
    <style>
        .loader {
            border: 10px solid #f3f3f3;
            border-radius: 50%;
            border-top: 5px solid blue;
            border-bottom: 5px solid blue;
            width: 50px;
            height: 50px;
            -webkit-animation: spin 2s linear infinite;
            animation: spin 2s linear infinite;
            margin-right: auto;
            margin-left: auto;
        }

        @-webkit-keyframes spin {
            0% { -webkit-transform: rotate(0deg); }
            100% { -webkit-transform: rotate(360deg); }
        }

        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
    </style>
@endsection
@section('content')
    @isset($error)

        @else
            <div class="row border-bottom">
                <div class="col-xs-12 col-md-6">
                    <span>فعال سازی سامانه</span>
                </div>
                <div class="col-xs-12 col-md-6 text-left">
                    <span>کد مجوز : </span><span>{{$license->code}}</span>
                </div>
            </div>
            <div class="row margin-top text-center">
                <p class="p-detail">اطلاعات زیر را با دقت وارد کنید پس از فعال سازی ویرایش امکان پذیر نیست. درصورتی که نیاز به مشاوره و راهنمایی دارید پیش از فعال سازی با پشتیبانی فنی تماس حاصل نمایید.</p>
            </div>
            <div class="row margin-top text-center">
                @if($license->iscompleted == 0)
                    <p>دامنه خود را بطور کامل همراه با پسوند وارد کنید.</p>
                    <span dir="ltr">
                <input type="text" id="domain" dir="ltr" class="input-domain" style="font-family: 'Arial'" placeholder="domain" autofocus>
            </span>
                    <br>
                    <button id="postbutton" class="button-check">بررسی</button><br>
                    <div class="loader hidden"></div>
                    <form action="{{route('dash_reg_license')}}" method="post">
                        @csrf
                        <input name="code" type="hidden" value="{{$license->code}}">
                        <input name="prefix" id="domain-prefix" type="hidden" value="">
                        <input name="suffix" id="domain-suffix" type="hidden" value="">
                        <button type="submit" id="submit-domain" class="button-active hidden" disabled>ثبت و فعال سازی</button>
                    </form>
                    <p class="text-danger hidden alert-domain" id="invalid-domain">دامنه نامعتبر است</p>
                    <p class="text-danger hidden alert-domain" id="unavailable-domain">این دامنه قبلا ثبت شده است</p>
                    <p class="text-danger hidden alert-domain" id="null-domain">لطفا دامنه را وارد کنید</p>
                    <p class="text-success hidden alert-domain" id="accept-domain">دامنه صحیح است</p>
                @endif
            </div>
            @endisset
@endsection

@section('footer')
    <script>
        var CSRF_TOKEN = "{{ csrf_token() }}";
        var URL = "{{route('dash_validate_domain')}}";
        $("#postbutton").click(function(){
            var domain = $("#domain").val();
            $('.loader').removeClass('hidden');
            $('.alert-domain').addClass('hidden');
            $("#submit-domain").addClass('hidden');
            $.ajax({
                url: URL,
                type: 'POST',
                data: {_token: CSRF_TOKEN, domain:domain},
                dataType: 'JSON',
                success: function (data) {
                    console.log(data);
                    if(data.status == 1){
                        setTimeout(function(){
                            $("#submit-domain").removeClass('hidden').removeAttr('disabled');
                            $('#domain-prefix').val(data.prefix);
                            $('#domain-suffix').val(data.suffix);
                            $('.loader').addClass('hidden');
                            $('#accept-domain').removeClass('hidden');
                        } , 500);
                    }else if(data.status == 3){
                        $('#domain-input').val('');
                        setTimeout(function() {
                            $('.loader').addClass('hidden');
                            $('#null-domain').removeClass('hidden');
                        } , 500);
                    }else if(data.status == 0){
                        $('#domain-input').val('');
                        setTimeout(function() {
                            $('.loader').addClass('hidden');
                            $('#unavailable-domain').removeClass('hidden');
                        } , 500);
                    }else{
                        $('#domain-input').val('');
                        setTimeout(function() {
                            $('.loader').addClass('hidden');
                            $('#invalid-domain').removeClass('hidden');
                        } , 500);
                    }
                }
            });
        });
    </script>
@endsection