@extends('layouts.dashboard')

@section('content')
    <div class="row border-bottom">
        <div class="col-xs-12 col-md-6">
            <span>خرید بسته پیامکی</span>
        </div>
        <div class="col-xs-12 col-md-6 text-left">
            <span>کد مجوز : </span><span>{{$license->code}}</span>
        </div>
    </div>
    <div class="row margin-top border-bottom">
        <form action="{{route('dash_add_sms_basket')}}" method="post">
            @csrf
            <input name="key" value="{{$license->code}}" type="hidden">
            <div class="table-responsive">
                <table class="table">
                    <thead>
                    <tr>
                        <th>ردیف</th>
                        <th>عنوان</th>
                        <th>بسته ها</th>
                        <th>قیمت</th>
                    </tr>
                    </thead>
                    <tbody>
                    <tr>
                        <td>1</td>
                        <td>اعتبار پیامکی</td>
                        <td>
                            <select data-value="{{$price}}" name="sms" class="form-control select-sms-padding sms-item" id="form-sms-select">
                                <option value="500">بسته پیامک 500</option>
                                <option value="1000">بسته پیامکی 1000</option>
                                <option value="1500">بسته پیامکی 1500</option>
                                <option value="2000">بسته پیامکی 2000</option>
                            </select>
                        </td>
                        <td>
                            <span id="basket_price">{{$default_price}}</span><span> ریال</span>
                        </td>
                    </tr>
                    </tbody>
                </table>
            </div>
            <div class="row text-left">
                <button type="submit" class="button-pay" >تکمیل سفارش</button>
            </div>
        </form>
    </div>
@endsection

@section('footer')
    <script>
        function update_price() {
            var new_price  = parseInt($('#form-sms-select').val()) * parseInt($('#form-sms-select').attr('data-value'));
            $.ajax({
                url: "{{route('home_number_format')}}",
                type: 'POST',
                data: {new_price:new_price},
                dataType: 'JSON',
                success: function (data) {
                    $('#basket_price').html(data.price);
                }
            });
        }

        $('.sms-item').change(function () {
            update_price();
        });

    </script>
@endsection