@extends('layouts.dashboard')

@section('content')
    <div class="row row-padding">
        <div class="col-xs-12">
            <table class="table">
                <thead>
                <tr>
                    <th>ردیف</th>
                    <th>عنوان</th>
                    <th>نوع بسته</th>
                    <th>مبلغ</th>
                </tr>
                </thead>
                <tbody>
                <tr>
                    <td>1</td>
                    <td>بسته پیامکی</td>
                    <td><span>{{$quantity}}</span> <span>تایی</span></td>
                    <td><span>{{$amount}}</span> <span>ریال</span></td>
                </tr>
                </tbody>
            </table>
            @if(session()->has('message'))
                <div class="text-center alert-danger">{{session()->get('message')}}</div>
            @endif
            @if($status == 1)
                <div class="text-center alert-success discount-alert">کد تخفیف با موفقیت اعمال شد</div>
            @elseif($status == 0)
                <div class="text-center alert-danger discount-alert">کد تخفیف وارد شده نا معتبر است</div>
            @endif

            @if(session()->has('discount_status'))
                <ul>
                    <li>
                        <span>کد تخفیف :</span>
                        <span>{{session()->get('discount_status')[1]}}</span>
                        <span><a href="{{route('dash_sms_discount_delete' , session()->get('discount_status')[1])}}" class="alert-danger"> X </a></span>
                    </li>
                </ul>
            @else
            <form action="{{route('dash_sms_discount')}}" method="post">
                @csrf
                <input type="text" name="discount" class="discount-shop-input" id="exampleFormControlInput4" placeholder="کد تخفیف خود را وارد کنید" >
                <button class="discount-shop-button"> اعمال کد تخفیف </button>
            </form>
            @endif

        </div>
    </div>
    <div class="row margin-top">
        <div class="col-xs-12 col-md-6"></div>
        <div class="col-xs-12 col-md-6">
            <p><span>مبلغ صورتحساب  :  </span><span class="padding-span">{{$amount}}</span><span>ریال</span><br></p>
            <p><span>مبلغ تخفیف :  </span><span class="padding-span">{{$amount_discount}}</span><span>ریال</span><br></p>
            <p><span>حساب کیف پول :  </span><span class="padding-span">{{$wallet}}</span><span>ریال</span></p>
            <p><span>مبلغ قابل پرداخت (با 9 درصد مالیت بر ارزش افزوده) :  </span><span class="padding-span">{{$pay}}</span><span>ریال</span></p>
            <a href="{{route('dash_sms_save_basket')}}"><button class="button-pay" >پرداخت</button></a>
        </div>
    </div>
@endsection