@extends('layouts.dashboard')

@section('header')
    <script src="{{ asset('dashboard/css/datatables.css') }}"></script>
@endsection

@section('content')
    <table id="licenses" class="table" cellspacing="0" width="100%">
        <thead>
        <tr>
            <th>ردیف</th>
            <th>کد مجوز</th>
            <th>دامنه </th>
            <th>تاریخ اتمام مجوز</th>
            <th>وضعیت</th>
        </tr>
        </thead>
        <tfoot>
        <tr>
            <th>ردیف</th>
            <th>کد مجوز</th>
            <th>دامنه </th>
            <th>تاریخ اتمام مجوز</th>
            <th>وضعیت</th>
        </tr>
        </tfoot>
        <tbody>
        @foreach($licenses as $value)
            <tr>
                <td><a href="{{route('dash_license' , $value->code)}}">{{$loop->iteration}}</a></td>
                <td><a href="{{route('dash_license' , $value->code)}}">{{$value->code}}</a></td>
                @if($value->domain == '')
                    <td><a href="{{route('dash_license' , $value->code)}}">دامنه ندارد</a></td>
                    <td><a href="#">-</a></td>
                @else
                    <td><a href="{{route('dash_license' , $value->code)}}">{{$value->domain.'.'.strtolower($value->suffix_domain)}}</a></td>
                    <td><a href="{{route('dash_license' , $value->code)}}">{{\App\Traits\Date::dateView($value->expire_date , $language)}}</a></td>
                @endif
                @if($value->status)
                    <td><a href="{{route('dash_license' , $value->code)}}">فعال</a></td>
                @else
                    <td><a href="{{route('dash_license' , $value->code)}}">غیرفعال</a></td>
                @endif
            </tr>
        @endforeach
        </tbody>
    </table>
    <div>
        <div>
            {{$licenses->links()}}
        </div>
    </div>
@endsection

@section('footer')
    <script src="{{ asset('dashboard/js/datatables.js') }}"></script>
    <script>
    $(document).ready(function() {
    var table = $('#licenses').DataTable( {
    responsive: true,
    bFilter: false,
    bInfo: false,
    "paging":   false,
    "bLengthChange": false,
    'info' : false,
    "order": [],

    } );
    } );

    </script>
@endsection