@extends('layouts.dashboard')

@section('content')
    <div class="row border-bottom">
        <div class="col-xs-12 col-md-6">
            <span>مشخصات سامانه</span>
        </div>
        <div class="col-xs-12 col-md-6"></div>
    </div>
    <div class="row row-padding">
        <div class="col-xs-12 col-md-6">
            <p><span>کد مجوز :  </span><span class="padding-span">{{$license->code}}</span><br></p>
            <p><span>اعتبار پیامک :  </span><span class="padding-span">{{$license->sms_balance}}</span><br></p>
            <p><span>اعتبار عمومی :  </span><span class="padding-span">{{$license->public_balance}}</span></p>
            <p><span>اعتبار خصوصی :  </span><span class="padding-span">{{$license->private_balance}}</span></p>
            <p><span>اعتبار نیمه خصوصی :  </span><span class="padding-span">{{$license->halfprivate_balance}}</span></p>
        </div>
        <div class="col-xs-12 col-md-6">
            <p><span>دامنه :  </span>
            @if($license->domain == '')
                <span class="padding-span">دامنه ندارد</span>
            @else
                <span class="padding-span">{{$license->domain.'.'.strtolower($license->suffix_domain)}}</span>
            @endif
            <br></p>
            <p><span>تاریخ فعال سازی :  </span><span class="padding-span">{{\App\Traits\Date::dateView($license->expire_date , $language)}}</span><br></p>
            <p><span>وضعیت :  </span>
            @if($license->status)
                <span class="padding-span">فعال</span>
            @else
                <span class="padding-span">غیر فعال</span>
            @endif
            </p>
        </div>
    </div>
    <div class="row margin-top">
        @if($license->has_domain == 1 && $license->domain == '')
            <div class="col-md-4 col-xs-12"><a href="{{route('dash_activation_with_domain' , $license->code)}}"><button class="button-label"> اختصاص دامنه </button></a> </div>
        @endif
        <div class="col-md-4 col-xs-12"><a href="{{route('dash_credit_assign_form' , $license->code)}}"><button class="button-label"> افزایش اعتبار ایجاد دوره </button></a> </div>
        <div class="col-md-4 col-xs-12"><a href="{{route('dash_sms_assign_form' , $license->code)}}"><button class="button-label"> افزایش اعتبار پیامک </button></a> </div>
    </div>
@endsection