@extends('layouts.dashboard')

@section('content')
    <div class="row border-bottom">
        <div class="col-xs-12 col-md-6">
            <span>فعال سازی سامانه</span>
        </div>
        <div class="col-xs-12 col-md-6 text-left">
            <span>کد مجوز : </span><span>{{$license->code}}</span>
        </div>
    </div>
    <div class="row margin-top border-bottom">
        <form action="{{route('dash_add_credit_basket')}}" method="post">
            @csrf
            <input name="key" value="{{$key}}" type="hidden">
            <div class="table-responsive">
                <table class="table">
                    <thead>
                    <tr>
                        <th>ردیف</th>
                        <th>عنوان</th>
                        <th>تعداد</th>
                        <th>قیمت</th>
                    </tr>
                    </thead>
                    <tbody>
                    <tr>
                        <td>1</td>
                        <td>اعتبار عمومی</td>
                        <td>
                            <input data-value="{{$public_price}}" min="0" type="number" class="form-control input-shop credit-course" name="public" id="public" placeholder="" value="1">
                        </td>
                        <td>
                            <span id="public-price">{{number_format($public_price)}}</span><span> ریال</span>
                        </td>
                    </tr>
                    <!--
                    <tr>
                        <td>2</td>
                        <td>اعتبار خصوصی</td>
                        <td>
                            <input data-value="{{$private_price}}" min="0" type="number" class="form-control input-shop credit-course" name="private" id="private" placeholder="" value="0">
                        </td>
                        <td>
                            <span id="private-price">0</span><span> ریال</span>
                        </td>
                    </tr>
                    <tr>
                        <td>3</td>
                        <td>اعتبار نیمه خصوصی</td>
                        <td>
                            <input data-value="{{$hprivate_price}}" min="0" type="number" class="form-control input-shop credit-course" name="half_private" id="half_private" value="0">
                        </td>
                        <td>
                            <span id="half_private-price">0</span><span> ریال</span>
                        </td>
                    </tr>
                    -->
                    </tbody>
                </table>
            </div>
            <div class="row text-left">
                <button type="submit" class="button-pay" >تکمیل سفارش</button>
            </div>
        </form>
    </div>
@endsection

@section('footer')
    <script>
        function update_price(id) {
            var new_price       = parseInt($('#'+id).val()) * parseInt($('#'+id).attr('data-value'));
            $.ajax({
                url: "{{route('home_number_format')}}",
                type: 'POST',
                data: {new_price:new_price},
                dataType: 'JSON',
                success: function (data) {
                    $('#'+id+'-price').html(data.price);
                }
            });
        }
        $('.credit-course').change(function () {
            var num = parseInt($('#public').val()) + parseInt($('#private').val()) + parseInt($('#half_private').val());
            if(num < 1){
                $(this).val(1);
            }
            var id = $(this).attr('id');
            update_price(id);
        });

    </script>
@endsection