@extends('layouts.dashboard')

@section('header')
    <script src="{{ asset('dashboard/css/datatables.css') }}"></script>
@endsection

@section('content')
    <table id="invoices" class="table" cellspacing="0" width="100%">
        <thead>
        <tr>
            <th>ردیف</th>
            <th>شماره صورتحساب</th>
            <th>تاریخ ایجاد</th>
            <th>مبلغ پرداختی(ریال)</th>
        </tr>
        </thead>
        <tfoot>
        <tr>
            <th>ردیف</th>
            <th>شماره صورتحساب</th>
            <th>تاریخ ایجاد</th>
            <th>مبلغ پرداختی(ریال)</th>
        </tr>
        </tfoot>
        <tbody>
        @foreach($invoices as $invoice)
            <tr>
                <td><a href="{{route('dash_invoice',$invoice->order_id)}}">{{$loop->iteration}}</a></td>
                <td><a href="{{route("dash_invoice",$invoice->order_id)}}">{{$invoice->order_id}}</a></td>
                <td><a href="{{route("dash_invoice",$invoice->order_id)}}">{{\App\Traits\Date::toJalali($invoice->order_date)}}</a></td>
                <td><a href="{{route("dash_invoice",$invoice->order_id)}}">{{number_format(intval($invoice->order_amount))}}</a></td>
            </tr>
        @endforeach
        </tbody>
    </table>
    <div class="table-buttons">
        <div>
            {{$invoices->links()}}
        </div>
    </div>
@endsection

@section('footer')
    <script src="{{ asset('dashboard/js/datatables.js') }}"></script>
    <script>
        $(document).ready(function() {
            var table = $('#invoices').DataTable( {
                responsive: true,
                bFilter: false,
                bInfo: false,
                "paging":   false,
                "bLengthChange": false,
                'info' : false,
                "order": [],

            } );
        } );

    </script>
@endsection