@extends('layouts.dashboard')

@section('header')

@endsection

@section('content')
    <div class="row border-bottom">
        <div class="col-xs-12 col-md-6">
            <span>شماره صورت حساب : </span><span>{{$invoice->order_id}}</span>
        </div>
        <div class="col-xs-12 col-md-6">
            <span>تاریخ صورت حساب : </span><span>{{\App\Traits\Date::toJalali($invoice->order_date)}}</span>
        </div>
    </div>
    <div class="row row-padding">
        <div class="col-xs-12 col-md-6">
            <p><span>نام فروشنده :  </span><span class="padding-span">شرکت توسعه ایده و آگاهی سیمرغ</span><br></p>
            <p><span>تلفن :  </span><span class="padding-span" dir="ltr">021 - 88065876</span><br></p>
            <p><span>نشانی :  </span><span class="padding-span">ﺗﻬﺮان، ﺷﯿﺦ ﺑﻬﺎﯾﯽ ﺷﻤﺎﻟﯽ، ﺑﺮج ﺻﺒﺎ، واﺣﺪ 53</span></p>
        </div>
        <div class="col-xs-12 col-md-6">
            <p><span>نام خریدار :  </span><span class="padding-span">{{ $invoice->user_name." ".$invoice->user_family }}</span><br></p>
            <p><span>تلفن :  </span><span class="padding-span">{{$invoice->user_mobilenumber}}</span><br></p>
        </div>
    </div>
    <div class="row row-padding">
        <div class="col-xs-12">
            <table class="table">
                <thead>
                <tr>
                    <th>ردیف</th>
                    <th>عنوان</th>
                    <th>تعداد</th>
                    <th>مبلغ(ریال)</th>
                </tr>
                </thead>
                <tbody>
                @foreach($invoice->products as $product)

                    @if($product->product_code!= config('global.SKU_DISCOUNT') && $product->product_code!= config('global.SKU_DISCOUNT_YEKITA') && $product->product_code!= config('global.SKU_DISCOUNT_SMS') && $product->product_code!= config('global.SKU_DISCOUNT_CREDIT'))

                        <tr>
                            <td>{{$loop->iteration}}</td>
                            <td class="primary-color uk-text-large">{{__('dashboard.'.$product->product_name)}}</td>
                            <td>{{$product->quantity}}</td>
                            <td>{{number_format(intval($product->price * $product->quantity))}}</td>
                        </tr>
                    @endif

                @endforeach
                </tbody>
            </table>
        </div>
    </div>
    <div class="row margin-top">
        <div class="col-xs-12 col-md-6"></div>
        <div class="col-xs-12 col-md-6">
            <p><span>جمع کل  :  </span><span class="padding-span">{{number_format(intval($invoice->pricewithoutRebate))}} ریال</span><br></p>
            <p><span>مبلغ تخفیف :  </span><span class="padding-span">{{number_format(intval($invoice->order_rebate))}} ریال</span><br></p>
            <p><span>مبلغ پرداختی :  </span><span class="padding-span">{{number_format(intval($invoice->order_amount))}} ریال</span></p>
            <button class="button-print" onclick="myFunction()">چاپ</button>
        </div>
    </div>
@endsection

@section('footer')
<script>
    function myFunction() {
        window.print();
    }
</script>
@endsection