@extends('layouts.admin_login')

@section('content')

    <div class="uk-grid">
        <div class="uk-width-1-1 uk-text-center uk-margin-small-top uk-margin-small-bottom uk-hidden@l fixed-header" id="header-mobile">
            تغییر کلمه عبور
        </div>
    </div>
    <div class="login_page_wrapper">
        <div class="md-card" id="login_card">
            <div class="md-card-content large-padding" id="login_password_reset">
                <h2 class="heading_a uk-margin-large-bottom">تغییر کلمه عبور</h2>
                @if (session('status'))
                    <div class="alert alert-success" role="alert">
                        {{ session('status') }}
                    </div>
                @endif
                <form method="POST" action="{{ route('password.email') }}" aria-label="{{ __('Reset Password') }}" class="uk-form-stacked">
                    @csrf

                    <div class="uk-form-row">
                        <label for="email">آدرس پست الکترونیک</label>
                        <input class="md-input" type="email" id="email" name="email" value="{{ old('email') }}" required/>
                        @if ($errors->has('email'))
                            <span class="invalid-feedback" role="alert">
                                        <small>{{ $errors->first('email') }}</small>
                                    </span>
                        @endif
                    </div>
                    <div class="uk-margin-medium-top">
                        <button type="submit" class="no-padding md-btn md-btn-primary md-btn-large md-btn-wave-light waves-effect waves-button waves-light md-btn-block">
                            ارسال لینک تغییر کلمه عبور
                        </button>
                      </div>
                </form>
            </div>
        </div>
    </div>
@endsection
