@extends('layouts.admin_login')

@section('content')

    <div class="uk-grid">
        <div class="uk-width-1-1 uk-text-center uk-margin-small-top uk-margin-small-bottom uk-hidden@l fixed-header" id="header-mobile">
            ورود به ناحیه کاربری
        </div>
    </div>
    <div class="login_page_wrapper">
        <div class="md-card" id="login_card">
            <div class="md-card-content large-padding" id="login_form">
                <form method="POST" action="{{ route('login') }}" aria-label="{{ __('auth.Login') }}">
                    @csrf
                    <div class="md-input-wrapper md-input-filled">
                        <label for="email">آدرس پست الکترونیک</label>
                        <input class="md-input" type="email" id="email" name="email" value="{{ old('email') }}" />
                        @if ($errors->has('email'))
                            <span class="invalid-feedback" role="alert">
                                        <small>{{ $errors->first('email') }}</small>
                                    </span>
                        @endif
                    </div>
                    <div class="md-input-wrapper md-input-filled">
                        <label for="password">رمز عبور</label>
                        <input class="md-input" type="password" id="password" name="password" />
                        @if ($errors->has('password'))
                            <span class="invalid-feedback" role="alert">
                                        <small>{{ $errors->first('password') }}</small>
                                    </span>
                        @endif
                    </div>
                    <div class="uk-form-row uk-text-center">
                        <a href="{{ route('password.request') }}" id="#">بازیابی کلمه عبور</a>
                    </div>
                    <div class="uk-margin-medium-top">
                        <input type="submit" value="ورود" name="submit" class="no-padding md-btn md-btn-primary md-btn-large md-btn-wave-light waves-effect waves-button waves-light md-btn-block">
                    </div>
                </form>
            </div>
        </div>
    </div>

@endsection
