@extends('layouts.admin')

@section('content')

    <div class="uk-grid">
        <div class="uk-width-1-1 uk-text-center uk-margin-small-top uk-margin-small-bottom uk-hidden@l" id="header-mobile">
            لیست وبسایت
        </div>
    </div>
    <div id="page_content_inner">
        <div class="uk-container uk-align-center">
            <div class="uk-grid" data-uk-grid-match id="slider_lists">
                <div class="uk-width-large-1-1">
                    <div class="md-card uk-margin-medium-bottom">
                        <div class="md-card-content">
                            <h2 class="heading_b uk-margin-bottom">لیست وبسایت</h2>
                            <form method="get" action="">
                                <div class="uk-grid" data-uk-grid-margin style="margin-bottom: 50px">
                                    <div class="uk-width-medium-1-5">
                                        <div class="uk-form-row">
                                            <div class="parsley-row">
                                                <div class="md-input-wrapper">
                                                    <label for="user-cellphone">کد مجوز</label>
                                                    <input type="text" name="code" value="{{key_exists("code",$search)?$search['code']:null}}"  class="md-input input-search">
                                                    <span class="md-input-bar"></span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="uk-width-medium-1-5">
                                        <div class="uk-form-row">
                                            <div class="parsley-row">
                                                <div class="md-input-wrapper">
                                                    <label for="user-cellphone">دامین</label>
                                                    <input type="text" name="domain" value="{{key_exists("domain",$search)?$search['domain']:null}}"  class="md-input input-search">
                                                    <span class="md-input-bar"></span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="uk-width-medium-1-5">
                                        <div class="uk-form-row">
                                            <div class="parsley-row">
                                                <div class="md-input-wrapper">
                                                    <select name="status" data-md-selectize>
                                                        <option value="">وضعیت  (همه)</option>
                                                        <optgroup label="وضعیت دوره(همه)">
                                                            <option value="1">فعال</option>
                                                            <option value="0" >غیر فعال</option>
                                                        </optgroup>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <input type="submit" value="جستجو" class="button-search">
                            </form>
                            <div class="uk-overflow-container">
                                <table id="news-articles" class="uk-table uk-table-hover uk-text-nowrap" cellspacing="0" width="100%">
                                    <thead>
                                    <tr>
                                        <th>کد مجوز</th>
                                        <th>لینک</th>
                                        <th>وضعیت</th>
                                    </tr>
                                    </thead>
                                    <tfoot>
                                    <tr>
                                        <th>کد مجوز</th>
                                        <th>لینک</th>
                                        <th>وضعیت</th>

                                    </tr>
                                    </tfoot>
                                    <tbody>
                                    @foreach($licenses as $license)

                                        <tr>
                                            <td>{{$license->code}}</td>
                                            <td><a href="http://{{($license->domain?$license->domain.'.'.strtolower($license->suffix_domain):'#')}}">{{($license->domain?$license->domain.'.'.strtolower($license->suffix_domain):'تعیین نشده')}}</a></td>
                                            <td>{{($license->status?'فعال':'غیر فعال')}}</td>

                                        </tr>

                                    @endforeach

                                    </tbody>
                                </table>
                                <div class="table-buttons">
                                    <div>
                                        {{$licenses->links()}}
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection