@extends('layouts.admin')

@section('content')

    <div class="uk-grid">
        <div class="uk-width-1-1 uk-text-center uk-margin-small-top uk-margin-small-bottom uk-hidden@l" id="header-mobile">
            اطلاعات کاربر
        </div>
    </div>
    <div id="page_content_inner">
        <div class="uk-container uk-container-small uk-align-center">
            <div class="uk-grid" data-uk-grid-margin>
                <div class="uk-width-medium-1-1 uk-align-center">
                    <div class="md-card">
                        <div class="md-card-content">
                            <div class="uk-grid uk-margin-small-bottom" data-uk-grid-margin>
                                <div class="uk-width-1-1 uk-text-center">
                                    <div class="course-image-wrapper uk-border-rounded">
                                        <img src="{{$user->avatar}}" alt="image">
                                    </div>
                                </div>
                            </div>
                            <div class="uk-grid uk-margin-top" data-uk-grid-margin>
                                <div class="uk-width-1-1 uk-margin-small-bottom">
                                    <div class="md-card">
                                        <div class="md-card-content">
                                            <label for="" class="heading_c secondary-color uk-margin-small-bottom block-label">مشخصات دوره</label>
                                            <div class="uk-text-left min-height-60">
                                                <ul class="md-list uk-grid" id="no-border-list">
                                                    <li class="uk-width-medium-1-2">
                                                        <div class="md-list-content">
                                                            <span class="md-list-heading">نام: </span>
                                                            <span class="uk-text-muted">{{$user->name}}</span>
                                                        </div>
                                                    </li>
                                                    <li class="uk-width-medium-1-2">
                                                        <div class="md-list-content">
                                                            <span class="md-list-heading">نام خانوادگی: </span>
                                                            <span class="uk-text-muted">{{$user->lastname}}</span>
                                                        </div>
                                                    </li>
                                                    <li class="uk-width-medium-1-2">
                                                        <div class="md-list-content">
                                                            <span class="md-list-heading">تاریخ تولد: </span>
                                                            <span class="uk-text-muted">{{\App\Traits\Date::toJalali($user->birthday)}}</span>
                                                        </div>
                                                    </li>
                                                    <li class="uk-width-medium-1-2">
                                                        <div class="md-list-content">
                                                            <span class="md-list-heading">جنسیت: </span>
                                                            <span class="uk-text-muted">{{($user->gender=='male'?"مرد":"زن")}}</span>
                                                        </div>
                                                    </li>
                                                    <li class="uk-width-medium-1-2">
                                                        <div class="md-list-content">
                                                            <span class="md-list-heading">شماره تلفن: </span>
                                                            <span class="uk-text-muted">{{$user->mobile_number}}</span>
                                                        </div>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="uk-width-medium-1-3 uk-margin-small-bottom">
                                    <div class="md-card">
                                        <a href="{{route("user_invoices",[$user->mobile_number])}}">
                                        <div class="md-card-content">
                                            <label for="" class="heading_c secondary-color uk-margin-small-bottom block-label">لیست صورت حساب</label>
                                            <div class="uk-text-left min-height-60">

                                            </div>
                                        </div>
                                        </a>
                                    </div>
                                </div>
                                <div class="uk-width-medium-1-3 uk-margin-small-bottom">
                                    <div class="md-card">
                                        <a href="{{route("user_websites",[$user->mobile_number])}}">
                                            <div class="md-card-content">
                                                <label for="" class="heading_c secondary-color uk-margin-small-bottom block-label">مشاهده وبسایت</label>
                                                <div class="uk-text-left min-height-60">

                                                </div>
                                            </div>
                                        </a>

                                    </div>
                                </div>
                                @hasanyrole('manager')
                                <div class="uk-width-medium-1-3 uk-margin-small-bottom">
                                    <div class="md-card">
                                            <div class="md-card-content">
                                                <label for="" class="heading_c secondary-color uk-margin-small-bottom block-label">مشاهده رویداد ها</label>
                                                <div class="uk-text-left min-height-60">

                                                </div>
                                            </div>

                                    </div>
                                </div>
                                @endhasanyrole
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection