@extends('layouts.admin')

@section('content')

    <div class="uk-grid">
        <div class="uk-width-1-1 uk-text-center uk-margin-small-top uk-margin-small-bottom uk-hidden@l" id="header-mobile">
            صورت حساب ها
        </div>
    </div>
    <div id="page_content_inner">
        <div class="uk-container uk-align-center">
            <div class="uk-grid" data-uk-grid-match id="bill_lists">
                <div class="uk-width-large-1-1">
                    <div class="md-card uk-margin-medium-bottom">
                        <div class="md-card-content">
                            <div class="uk-overflow-container">
                                <table id="bills-lists" class="uk-table uk-table-hover uk-text-nowrap" cellspacing="0" width="100%">
                                    <thead>
                                    <tr>
                                        <th>پرداخت کننده</th>
                                        <th>دوره</th>
                                        <th>تاریخ</th>
                                        <th>مبلغ(ریال)</th>
                                    </tr>
                                    </thead>
                                    <tfoot>
                                    <tr>
                                        <th>پرداخت کننده</th>
                                        <th>دوره</th>
                                        <th>تاریخ</th>
                                        <th>مبلغ(ریال)</th>
                                    </tr>
                                    </tfoot>
                                    <tbody>
                                    @foreach($invoices as $invoice)

                                        <tr>
                                            <td><a href="{{route("user_invoice",[$invoice->order_id])}}">{{$invoice->user_name." ".$invoice->user_family}}</a></td>
                                            <td><a href="{{route("user_invoice",[$invoice->order_id])}}">{{$invoice->user_mobilenumber}}</a></td>
                                            <td><a href="{{route("user_invoice",[$invoice->order_id])}}">{{\App\Traits\Date::toJalali($invoice->order_date)}}</a></td>
                                            <td><a href="{{route("user_invoice",[$invoice->order_id])}}">{{$invoice->order_amount}}</a></td>
                                        </tr>
                                    @endforeach

                                    </tbody>
                                </table>
                                <div class="table-buttons">
                                    <div>
                                        {{$invoices->links()}}
                                    </div>
                                </div>
                                <div class="table-buttons uk-margin-top uk-margin-small-bottom uk-text-right"><span class="dt-button buttons-excel buttons-html5 md-btn md-btn-primary md-btn-wave-light waves-effect waves-button waves-light" id="excel-btn">دریافت فایل اکسل</span></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection