@extends('layouts.admin')

@section('content')

    <div class="uk-grid">
        <div class="uk-width-1-1 uk-text-center uk-margin-small-top uk-margin-small-bottom uk-hidden@l" id="header-mobile">
            صورت حساب ها
        </div>
    </div>
    <div id="page_content_inner">
        <div class="uk-container uk-align-center">
            <div class="uk-grid" data-uk-grid-margin id="bills-details">
                <div class="uk-width-large-1-1">
                    <div class="md-card uk-margin-medium-bottom">
                        <div class="md-card-content">
                            <h2 class="heading_b uk-margin-bottom">صورتحساب</h2>
                            <div class="bill-detail uk-margin-bottom">
                                <div class="uk-grid uk-grid-divider" data-uk-grid-margin>
                                    <div class="uk-width-large-1-2 uk-width-medium-1-2">
                                        <ul class="md-list">
                                            <li>
                                                <div class="md-list-content">
                                                    <div class="uk-grid" data-uk-grid-margin>
                                                        <div class="uk-width-medium-1-2">
                                                            <span>شماره صورتحساب</span>
                                                        </div>
                                                        <div class="uk-width-medium-1-2">
                                                            <span class="primary-color">{{$invoice->order_id}}</span>
                                                        </div>
                                                    </div>
                                                </div>
                                            </li>
                                            <li>
                                                <div class="md-list-content">
                                                    <div class="uk-grid" data-uk-grid-margin>
                                                        <div class="uk-width-medium-1-1">
                                                            <div class="uk-grid" data-uk-grid-margin>
                                                                <div class="uk-width-medium-1-2">
                                                                    <span>فروشنده</span>
                                                                </div>
                                                                <div class="uk-width-medium-1-2">
                                                                    <span class="primary-color">شرکت توسعه ایده و آگاهی سیمرغ</span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="uk-width-medium-1-1">
                                                            <div class="uk-grid" data-uk-grid-margin>
                                                                <div class="uk-width-medium-1-2">
                                                                    <span>تلفن</span>
                                                                </div>
                                                                <div class="uk-width-medium-1-2">
                                                                    <span class="primary-color" dir="ltr">021 - 88065876</span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="uk-width-medium-1-1">
                                                            <div class="uk-grid" data-uk-grid-margin>
                                                                <div class="uk-width-medium-1-2">
                                                                    <span>نشانی</span>
                                                                </div>
                                                                <div class="uk-width-medium-1-2">
                                                                    <span class="primary-color">ﺗﻬﺮان، ﺷﯿﺦ ﺑﻬﺎﯾﯽ ﺷﻤﺎﻟﯽ، ﺑﺮج ﺻﺒﺎ، واﺣﺪ 53</span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </li>
                                        </ul>
                                    </div>
                                    <div class="uk-width-large-1-2 uk-width-medium-1-2">
                                        <ul class="md-list">
                                            <li>
                                                <div class="md-list-content">
                                                    <div class="uk-grid" data-uk-grid-margin>
                                                        <div class="uk-width-medium-1-2">
                                                            <span>تاریخ صدور</span>
                                                        </div>
                                                        <div class="uk-width-medium-1-2">
                                                            <span class="primary-color">{{\App\Traits\Date::toJalali($invoice->order_date)}}</span>
                                                        </div>
                                                    </div>
                                                </div>
                                            </li>
                                            <li>
                                                <div class="md-list-content">
                                                    <div class="uk-grid" data-uk-grid-margin>
                                                        <div class="uk-width-medium-1-1">
                                                            <div class="uk-grid" data-uk-grid-margin>
                                                                <div class="uk-width-medium-1-2">
                                                                    <span>خریدار</span>
                                                                </div>
                                                                <div class="uk-width-medium-1-2">
                                                                    <span class="primary-color">{{ $invoice->user_name." ".$invoice->user_family }}</span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="uk-width-medium-1-1">
                                                            <div class="uk-grid" data-uk-grid-margin>
                                                                <div class="uk-width-medium-1-2">
                                                                    <span>تلفن</span>
                                                                </div>
                                                                <div class="uk-width-medium-1-2">
                                                                    <span class="primary-color">{{$invoice->user_mobilenumber}}</span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                                <div class="uk-grid uk-grid-divider" data-uk-grid-margin>
                                    <div class="uk-width-medium-1-1 uk-text-center">
                                        <div class="uk-overflow-container">
                                            <table class="uk-table uk-text-nowrap" id="bill-details-table">
                                                <thead>
                                                <tr>
                                                    <th class="uk-text-center">موضوع</th>
                                                    <th class="uk-text-center">تعداد</th>
                                                    <th class="uk-text-center">مبلغ(ریال)</th>
                                                </tr>
                                                </thead>
                                                <tbody>
                                                @foreach($invoice->products as $product)

                                                    @if($product->product_code!= config('global.SKU_DISCOUNT') && $product->product_code!= config('global.SKU_DISCOUNT_YEKITA') && $product->product_code!= config('global.SKU_DISCOUNT_SMS') && $product->product_code!= config('global.SKU_DISCOUNT_CREDIT'))

                                                        <tr>
                                                            <td>{{__('dashboard.'.$product->product_name)}}</td>
                                                            <td>{{$product->quantity}}</td>
                                                            <td>{{number_format(intval($product->price * $product->quantity))}}</td>
                                                        </tr>
                                                    @endif

                                                @endforeach
                                                <tr>
                                                    <td>جمع کل</td>
                                                    <td>{{number_format(intval($invoice->pricewithoutRebate))}} ریال</td>
                                                </tr>
                                                <tr>
                                                    <td>تخفیف</td>
                                                    <td>{{number_format(intval($invoice->order_rebate))}} ریال</td>
                                                </tr>
                                                <tr>
                                                    <td>مبلغ پرداختی</td>
                                                    <td>{{number_format(intval($invoice->order_amount))}} ریال</td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="uk-grid uk-margin-top" data-uk-grid-margin>
                                <div class="uk-width-medium-1-1 uk-text-center-small uk-text-right">
                                    <button class="md-btn md-btn-primary md-btn-wave-light waves-effect waves-button waves-light" id="cmd" onclick="myFunction()">چاپ</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection
@section('footer')
    <script>
        function myFunction() {
            window.print();
        }
    </script>
@endsection