@extends('layouts.admin')

@section('content')


<div id="page_content_inner">
    <div class="uk-container  uk-align-center">
        <div class="uk-grid" data-uk-grid-margin>
            <div class="uk-width-medium-1-1 uk-align-center">
                <div class="md-card">
                    <div class="md-card-content">
                        <h2 class="heading_b uk-margin-bottom uk-display-inline">محصولات</h2>
                        <a href="{{route('product_create')}}" class="uk-button uk-button-primary uk-align-left">اضافه کردن</a>
                        @if (session()->has('message'))
                        <div class="uk-alert-success uk-margin-medium-top uk-margin-large-bottom uk-padding-small" uk-alert>
                            <a class="uk-alert-close" uk-close></a>
                            <h4 style="color: white !important">{{session('message')}}</h4>
                        </div>
                        @endif
                        <div>
                            <table class="uk-table uk-table-hover uk-table-striped">
                                <thead>
                                    <tr>
                                        <th>عنوان</th>
                                        <th>قیمت</th>
                                        <th>نوع</th>
                                        <th>توضیحات</th>
                                        <th>مالیات</th>
                                        <th>عملیات</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($products as $product)
                                        <tr>
                                            <td>{{$product->name}}</td>
                                            <td>{{number_format($product->price)}}</td>
                                            <td>{{$product->type}}</td>
                                            <td>{{$product->description}}</td>
                                            <td>{{$product->tax}}</td>
                                            <td>
                                                <form action="{{route('product_delete',$product->id)}}" class="uk-display-inline" method="POST">
                                                    {{ csrf_field() }}
                                                    <button type="submit" class="uk-button uk-button-danger uk-button-small">
                                                        <span class="material-icons">
                                                            close
                                                        </span>    
                                                    </button>
                                                </form>
                                                
                                                <a href="{{route('product_edit',$product->id)}}" class="uk-button uk-button-primary uk-button-small">
                                                    <span class="material-icons">
                                                        edit
                                                    </span>   
                                                </a>
                                            </td>
                                        </tr>
                                    @endforeach

                                </tbody>
                            </table>

                        </div>

                    </div>
                </div>
            </div>

        </div>
    </div>
</div>

@endsection