@extends('layouts.admin')

@section('content')

<div id="page_content_inner">
    <div class="uk-container  uk-align-center">
        <div class="uk-grid" data-uk-grid-margin>
            <div class="uk-width-medium-1-1 uk-align-center">
                <div class="md-card">
                    <div class="md-card-content">
                        <h2 class="heading_b uk-margin-bottom uk-display-inline">اضافه کردن محصول</h2>
                        <a href="{{route('all_products')}}" class="uk-button uk-button-primary uk-align-left">بازگشت</a>
                        <form method="post" enctype="multipart/form-data">  
                        <div class="uk-margin-large-top uk-flex uk-flex-center">
                            <div>
                                    {{ csrf_field() }}                              
                                    <div class="uk-margin">
                                        <label for="">عنوان *</label>
                                        <input class="uk-input" type="text" placeholder="عنوان را وارد کنید" name="name" value="{{$product->name}}">
                                        @if ($errors->has('name'))
                                            <span class="span-error">
                                                <strong>{{ $errors->first('name') }}</strong>
                                            </span>
                                        @endif
                                    </div>

                                    <div class="uk-margin">
                                        <label for="">قیمت *</label>
                                        <input class="uk-input" type="text" placeholder="قیمت را وارد کنید" name="price" value="{{$product->price}}">
                                        @if ($errors->has('price'))
                                            <span class="span-error">
                                                <strong>{{ $errors->first('price') }}</strong>
                                            </span>
                                        @endif
                                    </div>

                                    <div class="uk-margin">
                                        <label for="">مالیات *</label>
                                        <input class="uk-input" type="text" placeholder="مالیات را به درصد وارد کنید" name="tax" value="{{(int)$product->tax}}">
                                        @if ($errors->has('tax'))
                                            <span class="span-error">
                                                <strong>{{ $errors->first('tax') }}</strong>
                                            </span>
                                        @endif
                                    </div>

                                    <div class="uk-margin">
                                        <label for="">نوع *</label>
                                        <select class="uk-select" name="type" id="">
                                            @foreach (App\Model\Product::PRODUCTS_TYPE as $item)
                                                <option {{$product->type == $item ? 'selected' : ''}} value="{{$item}}">{{$item}}</option>
                                            @endforeach
                                        </select>
                                        @if ($errors->has('type'))
                                            <span class="span-error">
                                                <strong>{{ $errors->first('type') }}</strong>
                                            </span>
                                        @endif
                                    </div>

                                    <div class="uk-margin-medium">
                                        <label for="default-platform">پیش فرض پلتفرم</label>
                                        <input class="uk-checkbox" type="checkbox" name="status" id="default-platform" value="1" {{$product->status ? 'checked' : ''}}>
                                    </div>

                                    <div class="uk-margin">
                                        <label for="">توضیحات </label>
                                        <textarea class="uk-textarea" name="description" id="" cols="30" rows="3">{{$product->description}}</textarea>
                                        @if ($errors->has('description'))
                                            <span class="span-error">
                                                <strong>{{ $errors->first('description') }}</strong>
                                            </span>
                                        @endif
                                    </div>



                                    
                                    <input type="submit" value="ایجاد" class="uk-button uk-button-primary uk-align-right">
                            </div>

                        </div>
                        </form>

                    </div>
                </div>
            </div>

        </div>
    </div>
</div>

@endsection

