@extends('layouts.admin')

@section('content')

<div id="page_content_inner">
    <div class="uk-container  uk-align-center">
        <div class="uk-grid" data-uk-grid-margin>
            <div class="uk-width-medium-1-1 uk-align-center">
                <div class="md-card">
                    <div class="md-card-content">
                        <h2 class="heading_b uk-margin-bottom uk-display-inline">اضافه کردن کد تخفیف</h2>
                        <a href="{{route('all_products')}}" class="uk-button uk-button-primary uk-align-left">بازگشت</a>
                        <form method="post" enctype="multipart/form-data">  
                        <div class="uk-margin-large-top uk-flex uk-flex-center">
                            <div>
                                    {{ csrf_field() }}                              
                                    <div class="uk-margin">
                                        <label for="">عنوان *</label>
                                        <input class="uk-input" type="text" placeholder="عنوان را وارد کنید" name="name" value="{{$discount->name}}">
                                        @if ($errors->has('name'))
                                            <span class="span-error">
                                                <strong>{{ $errors->first('name') }}</strong>
                                            </span>
                                        @endif
                                    </div>

                                    <div class="uk-margin">
                                        <label for="">کد تخفیف *</label>
                                        <input class="uk-input" type="text" placeholder="کد تخفیف را وارد کنید" name="code" value="{{$discount->code}}">
                                        @if ($errors->has('code'))
                                            <span class="span-error">
                                                <strong>{{ $errors->first('code') }}</strong>
                                            </span>
                                        @endif
                                    </div>

                                    <div class="uk-margin">
                                        <label for="">درصد تخفیف *</label>
                                        <input class="uk-input" type="text" placeholder="درصد تخفیف را وارد کنید" name="percentage" value="{{(int)$discount->percentage}}">
                                        @if ($errors->has('percentage'))
                                            <span class="span-error">
                                                <strong>{{ $errors->first('percentage') }}</strong>
                                            </span>
                                        @endif
                                    </div>

                                    <div class="uk-margin">
                                        <label for="">تاریخ انقضا *</label>
                                        <input class="uk-input" type="text" placeholder="تاریخ انقضا را وارد کنید" name="expire_at" value="{{$discount->expire_at}}">
                                        @if ($errors->has('expire_at'))
                                            <span class="span-error">
                                                <strong>{{ $errors->first('expire_at') }}</strong>
                                            </span>
                                        @endif
                                    </div>



                                    
                                    <input type="submit" value="ایجاد" class="uk-button uk-button-primary uk-align-right">
                            </div>

                        </div>
                        </form>

                    </div>
                </div>
            </div>

        </div>
    </div>
</div>

@endsection


