@extends('layouts.admin')

@section('content')


<div id="page_content_inner">
    <div class="uk-container  uk-align-center">
        <div class="uk-grid" data-uk-grid-margin>
            <div class="uk-width-medium-1-1 uk-align-center">
                <div class="md-card">
                    <div class="md-card-content">
                        <h2 class="heading_b uk-margin-bottom uk-display-inline">تنظیمات اسلایدر</h2>
                        <a href="{{route('slider_create')}}" class="uk-button uk-button-primary uk-align-left">اضافه کردن</a>
                        @if (session()->has('message'))
                        <div class="uk-alert-success uk-margin-medium-top uk-margin-large-bottom uk-padding-small" uk-alert>
                            <a class="uk-alert-close" uk-close></a>
                            <h4 style="color: white !important">{{session('message')}}</h4>
                        </div>
                        @endif
                        <div>
                            <table class="uk-table uk-table-hover uk-table-striped">
                                <thead>
                                    <tr>
                                        <th>عنوان</th>
                                        <th>عکس</th>
                                        <th>متن جایگزین</th>
                                        <th>عملیات</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($sliders as $slider)
                                        <tr>
                                            <td>{{$slider->title}}</td>
                                            <td><img src='{{asset("images/$slider->image")}}' alt=""  width="75"></td>
                                            <td>{{$slider->alt}}</td>
                                            <td>
                                                <form action="{{route('slider_delete',$slider->id)}}" class="uk-display-inline" method="POST">
                                                    {{ csrf_field() }}
                                                    <button type="submit" class="uk-button uk-button-danger uk-button-small">
                                                        <span class="material-icons">
                                                            close
                                                        </span>    
                                                    </button>
                                                </form>
                                                
                                                <a href="{{route('slider_edit',$slider->id)}}" class="uk-button uk-button-primary uk-button-small">
                                                    <span class="material-icons">
                                                        edit
                                                    </span>   
                                                </a>
                                            </td>
                                        </tr>
                                    @endforeach

                                </tbody>
                            </table>

                        </div>

                    </div>
                </div>
            </div>

        </div>
    </div>
</div>

@endsection