@extends('layouts.admin')


@section('header')
    <link rel="stylesheet" href="{{ asset('admin/assets/css/croppie.css') }}" media="all">
@endsection

@section('content')

<div id="page_content_inner">
    <div class="uk-container  uk-align-center">
        <div class="uk-grid" data-uk-grid-margin>
            <div class="uk-width-medium-1-1 uk-align-center">
                <div class="md-card">
                    <div class="md-card-content">
                        <h2 class="heading_b uk-margin-bottom uk-display-inline">اضافه کردن اسلایدر</h2>
                        <a href="{{route('slider_setting')}}" class="uk-button uk-button-primary uk-align-left">بازگشت</a>
                        <form method="post" enctype="multipart/form-data">  
                        <div class="uk-margin-large-top uk-flex uk-flex-center">
                            <div>
                                    {{ csrf_field() }}                              
                                    <div class="uk-margin">
                                        <label for="">عنوان *</label>
                                        <input class="uk-input" type="text" placeholder="عنوان را وارد کنید" name="title" value="{{old('title')}}">
                                        @if ($errors->has('title'))
                                            <span class="span-error">
                                                <strong>{{ $errors->first('title') }}</strong>
                                            </span>
                                        @endif
                                    </div>
                                    
                                    <div class="uk-margin">
                                        <label for="">متن جایگزین *</label>
                                        <input class="uk-input" type="text" placeholder="متن جایگزین را وارد کنید" name="alt" value="{{old('alt')}}">
                                        @if ($errors->has('alt'))
                                            <span class="span-error">
                                                <strong>{{ $errors->first('alt') }}</strong>
                                            </span>
                                        @endif
                                    </div>

                                    <div class="uk-margin">
                                        <label for="">ترتیب *</label>
                                        <input class="uk-input" type="text" placeholder="ترتیب را وارد کنید" name="order" value="{{old('order')}}">
                                        @if ($errors->has('order'))
                                            <span class="span-error">
                                                <strong>{{ $errors->first('order') }}</strong>
                                            </span>
                                        @endif
                                    </div>
                                    
                                    <div class="uk-margin">
                                        <label for="">لینک</label>
                                        <input class="uk-input" type="text" placeholder="لینک را وارد کنید" value="{{old('link')}}">
                                    </div>
                                    
                                    <input type="submit" value="ایجاد" class="uk-button uk-button-primary uk-align-right">
                            </div>

                            <div class="uk-margin-large-right">
                                <div class="" id="Div-image">
                                    <label class="heading_a secondary-color">تصویر </label>
                                    <div id="upload-demo"></div>
                                    <input type="hidden" id="image-code" name="image" value="">
                                    <input class="Upload_Croper" type="file" id="upload-image">
                                    <div class=" uk-margin-small-bottom" dir="ltr"> 650 * 368 </div>
                                    <button type="button" class="md-btn md-btn-primary md-btn-wave-light waves-effect waves-button waves-light Select_photo_croper">ویرایش</button>
                                    <button type="button" class="md-btn md-btn-danger md-btn-wave-light waves-effect waves-button waves-light remove_photo_croper">حذف</button>
                                    <div class="clearfix"><br></div>
                                    @if ($errors->has('image'))
                                        <span class="span-error">
                                            <strong>{{ $errors->first('image') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>
                        </form>

                    </div>
                </div>
            </div>

        </div>
    </div>
</div>

@endsection



@section('footer')
    
 <!-- Croppie -->
 <script src="{{ asset('admin/assets/js/croppie.js') }}"></script>

 <script type="text/javascript">

     //start image 1
     $uploadCrop = $('#upload-demo').croppie({
         enableExif: true,
         viewport: {
             width: 390,
             height: 180,
         },
         boundary: {
             width: 380,
             height: 170
         }
     });

     $('#upload-image').on('change', function () {
         var Id = $(this).parent().attr('id');
         $('#'+Id+' .cr-viewport').css('background-image' , 'none');
         var reader = new FileReader();
         reader.onload = function (e) {
             $uploadCrop.croppie('bind', {
                 url: e.target.result
             }).then(function(){
                 GetCode();
             });
         }
         reader.readAsDataURL(this.files[0]);
     });

     function GetCode() {
         $uploadCrop.croppie('result', {
             type: 'canvas',
             size: {
                 width: 520,
                 height: 252
             },
             format: "jpeg",
             quality: '0.9'
         }).then(function (resp) {
             $('#image-code').val(resp);
         });
     }

     $('.Select_photo_croper').click(function () {
         $('#upload-image').trigger('click');
     });

     $('.remove_photo_croper').on('click', function() {
         $('.cr-viewport').css('background-image' , 'none');
         $('.cr-image').attr('src', '');
         $('#upload-image').val('');
         $('#image-code').val('delete');
     });

     $('.cr-overlay').mouseup(function () {
         GetCode();
     });

     $('.cr-overlay').bind('mousewheel', function(e){
         GetCode();
     });
 </script>

@endsection
