@extends('layouts.admin')
@section('header')
    <style>
        .input-search{
            border: 0px;
            border-bottom: 1px solid #00aeef;
        }
        .button-search{
            max-width: 80px;
            font-size: 15px !important;
            margin-right: 10px;
        }
        .pagination ul{
            list-style: none;
            display: flex;
        }
        .pagination li{
            padding: 5px;
            list-style: none;
        }
    </style>
@endsection
@section('content')

    <div class="uk-grid">
        <div class="uk-width-1-1 uk-text-center uk-margin-small-top uk-margin-small-bottom uk-hidden@l" id="header-mobile">
            لیست درخواست ها
        </div>
    </div>
    <div id="page_content_inner">
        <div class="uk-container uk-align-center">
            <div class="uk-grid" data-uk-grid-match id="slider_lists">
                <div class="uk-width-large-1-1">
                    <div class="md-card uk-margin-medium-bottom">
                        <div class="md-card-content">
                            <h2 class="heading_b uk-margin-bottom"> لیست درخواست ها</h2>
                            <div class="uk-overflow-container">
                                <table id="courses" class="uk-table uk-table-hover uk-text-nowrap" cellspacing="0" width="100%">
                                    <thead>
                                    <tr>
                                        <th>شماره موبایل</th>
                                        <th>دوره درخواستی</th>
                                        <th>وضعیت</th>
                                    </tr>
                                    </thead>
                                    <tfoot>
                                    <tr>
                                        <th>شماره موبایل</th>
                                        <th>دوره درخواستی</th>
                                        <th>وضعیت</th>
                                    </tr>
                                    </tfoot>
                                    <tbody>
                                    @foreach($result as $value)
                                        <tr>
                                            <td><a href="/admin/courses/request/{{$value->id}}">{{$value->user}}</a></td>
                                            <td><a href="/admin/courses/request/{{$value->id}}">{{$value->course}}</a></td>
                                            <td><a href="/admin/courses/request/{{$value->id}}">@if($value->publish == 0) در انتظار انتشار @elseif($value->publish == 2) رد شده @elseif($value->publish == 1) تایید شده @endif</a></td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                </table>
                            </div>
                            <div class="pagination">
                                {{ $result->appends(request()->except('page'))->links() }}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection