@extends('layouts.admin')
@section('header')
    <style>
        .input-search{
            border: 0px;
            border-bottom: 1px solid #00aeef;
        }
        .button-search{
            max-width: 80px;
            font-size: 15px !important;
            margin-right: 10px;
        }
        .pagination ul{
            list-style: none;
            display: flex;
        }
        .pagination li{
            padding: 5px;
            list-style: none;
        }
    </style>
    @endsection
@section('content')

    <div class="uk-grid">
        <div class="uk-width-1-1 uk-text-center uk-margin-small-top uk-margin-small-bottom uk-hidden@l" id="header-mobile">
            دوره اموزشی
        </div>
    </div>
    <div id="page_content_inner">
        <div class="uk-container uk-align-center">
            <div class="uk-grid" data-uk-grid-match id="slider_lists">
                <div class="uk-width-large-1-1">
                    <div class="md-card uk-margin-medium-bottom">
                        <div class="md-card-content">
                            <h2 class="heading_b uk-margin-bottom">دوره های آموزشی</h2>
                            <form method="get" action="">
                                <div class="uk-grid" data-uk-grid-margin style="margin-bottom: 50px">
                                    <div class="uk-width-medium-1-5">
                                        <div class="uk-form-row">
                                            <div class="parsley-row">
                                                <div class="md-input-wrapper">
                                                    <input name="search" value="{{$search}}" class="md-input input-search" placeholder="جستجو">
                                                    <span class="md-input-bar"></span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="uk-width-medium-1-5">
                                        <div class="uk-form-row">
                                            <div class="parsley-row">
                                                <div class="md-input-wrapper">
                                                    <select name="state" data-md-selectize>
                                                        <option value="200">وضعیت دوره (همه)</option>
                                                        <optgroup label="وضعیت دوره(همه)">
                                                            <option value="1" @if($state == 1) selected @endif>انتشار یافته</option>
                                                            <option value="2" @if($state == 2) selected @endif>در انتظار انتشار</option>
                                                            <option value="3" @if($state == 3) selected @endif>رد شده</option>
                                                            <option value="0" @if($state == 0) selected @endif>رد شده توسط برگزارکننده</option>
                                                        </optgroup>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="uk-width-medium-1-5">
                                        <div class="uk-form-row">
                                            <div class="parsley-row">
                                                <div class="md-input-wrapper">
                                                    <input type="submit" value="جستجو" class="button-search">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </form>

                            <div class="uk-overflow-container">
                                <table id="courses" class="uk-table uk-table-hover uk-text-nowrap" cellspacing="0" width="100%">
                                    <thead>
                                    <tr>
                                        <th>نام دوره</th>
                                        <th>کد دوره</th>
                                        <th>برگزار کننده</th>
                                        <th>وضعیت</th>
                                    </tr>
                                    </thead>
                                    <tfoot>
                                    <tr>
                                        <th>نام دوره</th>
                                        <th>کد دوره</th>
                                        <th>برگزار کننده</th>
                                        <th>وضعیت</th>
                                    </tr>
                                    </tfoot>
                                    <tbody>
                                        @foreach($courses as $value)
                                            <tr>
                                                <td><a href="/admin/course/{{$value->id}}">{{$value->title}}</a></td>
                                                <td><a href="/admin/course/{{$value->id}}">{{$value->course_key}}</a></td>
                                                <td><a href="/admin/course/{{$value->id}}">{{$value->conductor}}</a></td>
                                                <td><a href="/admin/course/{{$value->id}}">@if($value->state == 2) در انتظار انتشار @elseif($value->state == 1) منتشر شده @elseif($value->state == 3)  رد شده @elseif($value->state == 0) رد شده توسط برگزارکننده @endif</a></td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                            <div class="pagination">
                                {{ $courses->appends(request()->except('page'))->links() }}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection