@extends('layouts.admin')
@section('header')
    <style>
       .form-width{
           width:100%
       }
        .textarea-style{
            width: 300px;
            border-color: #193e72;
            height: 50px;
        }
        .button-share{
            background-color: #d71921 !important;
        }

    </style>
    <link rel="stylesheet" href="{{ asset('admin/assets/multiple-select/multiple-select.css') }}" media="all">
@endsection
@section('content')
    <div class="uk-grid">
        <div class="uk-width-1-1 uk-text-center uk-margin-small-top uk-margin-small-bottom uk-hidden@l" id="header-mobile">
           {{ $course->title }}
        </div>
    </div>
    <div id="page_content_inner">
        <div class="uk-container uk-container-small uk-align-center">
            <div class="uk-grid" data-uk-grid-margin>
                <div class="uk-width-medium-1-1 uk-align-center">
                    <div class="md-card">
                        <div class="md-card-content">
                            <h2 class="heading_b uk-margin-bottom">
                                <a href="{{ $course->base_url . 'course/' . $course->course_key }}" target="_blank">
                                    {{ $course->title }}
                                </a>
                            </h2>
                            <div class="uk-grid uk-margin-small-bottom" data-uk-grid-margin>
                                <div class="uk-width-1-1 uk-text-center">
                                    <div class="course-image-wrapper uk-border-rounded">
                                        <img src="{{ $course->image }}" alt="{{ $course->title }}">
                                    </div>
                                </div>
                            </div>
                            <div class="uk-width-medium-1-1 uk-text-right uk-text-center-small">
                                <label style="text-align: center">
                                    @if($course->state == 0)
                                        <h2 style="color: crimson"> رد شده توسط برگزارکننده</h2>
                                        @elseif($course->state == 1)
                                        <h2 style="color: #aeea00"> منتشر شده</h2>
                                        @elseif($course->state == 2)
                                        <h2 style="color: #006400">در انتظار انتشار</h2>
                                        @elseif($course->state == 3)
                                        <h2 style="color: crimson"> رد شده</h2>
                                        <p>( {{$course->feedback}} )</p>
                                    @endif
                                </label>
                            </div>
                            <hr/>
                            <div class="uk-grid uk-margin-large-bottom">

                                @if($course->state == 1)
                                    <form method="POST" class="form-width" action="/admin/course/reject/{{ $course->id }}" aria-label="course update">
                                        @csrf
                                        @method('PUT')
                                        <div class="uk-width-medium-1-1 uk-text-center uk-text-center-small">
                                            <textarea name="feedback" class="textarea-style"></textarea><br>
                                            <input type="submit" value="عدم انتشار" class="md-btn md-btn-danger md-btn-wave-light waves-effect waves-button waves-light button-share">
                                        </div>
                                    </form>
                                @elseif($course->state == 2)
                                    <form method="POST" class="form-width" action="/admin/course/reject/{{ $course->id }}" aria-label="course update">
                                        @csrf
                                        @method('PUT')
                                        <div class="uk-width-medium-1-1 uk-text-center uk-text-center-small">
                                            <textarea name="feedback" class="textarea-style"></textarea><br>
                                            <input type="submit" value="عدم انتشار" class="md-btn md-btn-danger md-btn-wave-light waves-effect waves-button waves-light button-share">
                                            <a href="/admin/course/accept/{{$course->id}}" class="md-btn md-btn-primary md-btn-wave-light waves-effect waves-button waves-light">انتشار دوره</a>
                                        </div>
                                    </form>

                                @elseif($course->state == 3)
                                    <div class="uk-width-medium-1-1 uk-text-center uk-text-center-small">
                                        <a href="/admin/course/accept/{{$course->id}}" class="md-btn md-btn-primary md-btn-wave-light waves-effect waves-button waves-light">انتشار دوره</a>
                                    </div>
                                @endif
                            </div>
                            <div class="uk-grid uk-margin-top" data-uk-grid-margin>
                                <div class="uk-width-1-1 uk-margin-small-bottom">
                                    <div class="md-card">
                                        <div class="md-card-content">
                                            <label for="" class="heading_c secondary-color uk-margin-small-bottom block-label">مشخصات دوره</label>
                                            <div class="uk-text-left min-height-60">
                                                <ul class="md-list uk-grid" id="no-border-list">
                                                    <li class="uk-width-medium-1-2">
                                                        <div class="md-list-content">
                                                            <span class="md-list-heading">تاریخ ثبت: </span>
                                                            <span class="uk-text-muted">{{$course->create_date}}</span>
                                                        </div>
                                                    </li>
                                                    <li class="uk-width-medium-1-2">
                                                        <div class="md-list-content">
                                                            <span class="md-list-heading">کد دوره: </span>
                                                            <span class="uk-text-muted">{{$course->course_key}}</span>
                                                        </div>
                                                    </li>
                                                    <li class="uk-width-medium-1-2">
                                                        <div class="md-list-content">
                                                            <span class="md-list-heading">آدرس وبسایت: </span>
                                                            <span class="uk-text-muted"><a href="{{$course->base_url}}" target="_blank" style="direction: ltr;">{{$course->base_url}}</a></span>
                                                        </div>
                                                    </li>
                                                    <li class="uk-width-medium-1-2">
                                                        <div class="md-list-content">
                                                            <span class="md-list-heading">نوع دوره: </span>
                                                            <span class="uk-text-muted">تخصصی</span>
                                                        </div>
                                                    </li>
                                                    <li class="uk-width-medium-1-2">
                                                        <div class="md-list-content">
                                                            <span class="md-list-heading">برگزارکننده: </span>
                                                            <span class="uk-text-muted">{{$course->conductor}}</span>
                                                        </div>
                                                    </li>
                                                    <li class="uk-width-medium-1-2">
                                                        <div class="md-list-content">
                                                            <span class="md-list-heading">ظرفیت: </span>
                                                            <span class="uk-text-muted">{{$course->capacity}}</span>
                                                        </div>
                                                    </li>
                                                    <li class="uk-width-medium-1-2">
                                                        <div class="md-list-content">
                                                            <span class="md-list-heading">حد نصاب برگزاری: </span>
                                                            <span class="uk-text-muted">{{$course->quorum}}</span>
                                                        </div>
                                                    </li>

                                                    <li class="uk-width-medium-1-2">
                                                        <div class="md-list-content">
                                                            <span class="md-list-heading">تعداد ثبت نام: </span>
                                                            <span class="uk-text-muted">{{$participants}}</span>
                                                        </div>
                                                    </li>
                                                    <li class="uk-width-medium-1-2">
                                                        <div class="md-list-content">
                                                            <span class="md-list-heading">هزینه ثبت نام: </span>
                                                            <span class="uk-text-muted">{{$course->cost_register}}</span>
                                                        </div>
                                                    </li>

                                                    <li class="uk-width-medium-1-2">
                                                        <div class="md-list-content">
                                                            <span class="md-list-heading">تاریخ شروع: </span>
                                                            <span class="uk-text-muted">{{$course->date_start}}</span>
                                                        </div>
                                                    </li>
                                                    <li class="uk-width-medium-1-2">
                                                        <div class="md-list-content">
                                                            <span class="md-list-heading">تاریخ پایان: </span>
                                                            <span class="uk-text-muted">{{$course->date_end}}</span>
                                                        </div>
                                                    </li>
                                                    <li class="uk-width-medium-1-2">
                                                        <div class="md-list-content">
                                                            <span class="md-list-heading">مهلت ثبت نام: </span>
                                                            <span class="uk-text-muted">{{$course->date_register}}</span>
                                                        </div>
                                                    </li>

                                                    <li class="uk-width-medium-1-2">
                                                        <div class="md-list-content">
                                                            <span class="md-list-heading">گواهینامه: </span>
                                                            <span class="uk-text-muted">{{$course->certificate_title}}</span>
                                                        </div>
                                                    </li>
                                                    <li class="uk-width-medium-1-2">
                                                        <div class="md-list-content">
                                                            <span class="md-list-heading">تاریخ امتحان: </span>
                                                            <span class="uk-text-muted">{{$course->date_quiz}}</span>
                                                        </div>
                                                    </li>
                                                    <li class="uk-width-medium-1-2">
                                                        <div class="md-list-content">
                                                            <span class="md-list-heading">گروه بندی: </span>
                                                            <span class="uk-text-muted">
                                                                @foreach($course->group as $val)
                                                                    {{ \Illuminate\Support\Facades\Lang::get('course_group.'.$val) }} -
                                                                @endforeach
                                                            </span>
                                                        </div>
                                                    </li>
                                                </ul>
                                            </div>

                                            <div class="uk-text-left min-height-60">
                                                <hr/>
                                                <form action="{{route('course_new_course_group_insert' , [$course->id])}}" method="post">
                                                    @csrf
                                                    <div class="uk-form-row">
                                                        <div class="parsley-row">
                                                            <div class="md-input-wrapper">
                                                                <div class="uk-margin-small-bottom">
                                                                    <div class="md-input-wrapper md-input-focus">
                                                                        <label class="secondary-color">گروه بندی<span class="req">*</span></label>
                                                                    </div>
                                                                </div>
                                                                <select multiple="multiple" class="multiple-select">
                                                                    @foreach($course_group as $value)
                                                                        <option value="{{$value->name}}">{{ \Illuminate\Support\Facades\Lang::get('course_group.'.$value->name) }}</option>
                                                                    @endforeach
                                                                </select>
                                                                <input id="course_group" name="group" value="" type="hidden">
                                                                @if ($errors->has('group'))
                                                                    <span class="span-error">
                                                                        <strong>لطفا یک گروه انتخاب کنید</strong>
                                                                    </span>
                                                                @endif
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="uk-form-row">
                                                        <div class="parsley-row">
                                                            <div class="md-input-wrapper">
                                                                <button type="submit" class="waves-button-input">ثبت</button>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </form>
                                            </div>

                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('footer')
    <script src="{{ asset('admin/assets/multiple-select/multiple-select.js') }}"></script>
    <script>
        $(function(){
            var item = $('.multiple-select');
            item.multipleSelect({
                selectAll: false,
                allSelected: 'انتخاب همه',
            });

            $('input[type="checkbox"]').bind('change', function(){
                $('#course_group').val(item.multipleSelect("getSelects"));
            });
        });
    </script>
@endsection