@extends('layouts.admin')

@section('content')

    @if(count($data) != 0)
    <div class="uk-grid">
        <div class="uk-width-1-1 uk-text-center uk-margin-small-top uk-margin-small-bottom uk-hidden@l" id="header-mobile">
            {{ $data[0]->title }}
        </div>
    </div>
    <div id="page_content_inner">
        <div class="uk-container uk-container-small uk-align-center">
            <div class="uk-grid" data-uk-grid-margin>
                <div class="uk-width-medium-1-1 uk-align-center">
                    <div class="md-card">
                        <div class="md-card-content">
                            <div class="uk-grid uk-margin-small-bottom" data-uk-grid-margin>
                                <div class="uk-width-1-1 uk-text-center">
                                    <div class="course-image-wrapper uk-border-rounded">
                                        <img class="img-responsive" src="{{ asset('images/article/'.$data[0]->image) }}" alt="{{ $data[0]->title }}">
                                    </div>
                                </div>
                            </div>
                            <div class="uk-grid uk-margin-top" data-uk-grid-margin>
                                <div class="uk-width-1-1 uk-margin-small-bottom">
                                    <div class="md-card">
                                        <div class="md-card-content">
                                            <label for="" class="heading_c secondary-color uk-margin-small-bottom block-label">{{ $data[0]->title }}</label>
                                            <div class="uk-text-left min-height-60">
                                                {{ $data[0]->sub_title }}
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="uk-grid uk-text-center" data-uk-grid-margin="">
                                <div class="uk-width-1-1 uk-align-center uk-row-first">
                                    <div class="uk-grid uk-text-center" data-uk-grid-margin="">
                                        <div class="uk-width-medium-1-2 uk-text-center-medium uk-text-right">
                                            <form method="POST" action="{{ route('destory_blog' , $data[0]->blog_id) }}" aria-label="{{ __('Register') }}">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="md-btn md-btn-danger md-btn-block md-btn-wave-light waves-effect waves-button waves-light box-max-200" id="remove-class">حذف</button>
                                            </form>
                                        </div>
                                        <div class="uk-width-medium-1-2 uk-text-center-medium uk-text-left uk-row-first">
                                            <a href="/admin/blog/lang/{{ $id }}" class="no-padding md-btn md-btn-primary md-btn-block md-btn-wave-light waves-effect waves-button waves-light box-max-200 waves-input-wrapper">ویرایش</a>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="uk-grid" data-uk-grid-margin>
                                <div class="uk-width-medium-1-2">
                                    <form method="POST" action="{{ route('chang_status' , $data[0]->blog_id) }}">
                                        @csrf
                                        <div class="uk-grid">
                                            <div class="uk-width-1-1 uk-margin-small-bottom">
                                                <label class="secondary-color">وضعیت انتشار</label>
                                            </div>
                                            <div class="uk-width-1-1">
                                                        <span class="icheck-inline">
                                                            <input type="radio" id="radio_demo_inline_1" @if($blog_status->status == 'active') checked @endif value="active" name="status" data-md-icheck />
                                                            <label for="radio_demo_inline_1" class="inline-label">فعال</label>
                                                        </span>
                                                <span class="icheck-inline">
                                                            <input type="radio" id="radio_demo_inline_2" @if($blog_status->status == 'inactive') checked @endif value="inactive" name="status" data-md-icheck />
                                                            <label for="radio_demo_inline_2" class="inline-label">غیر فعال</label>
                                                        </span>
                                            </div>
                                        </div>
                                        <div class="uk-grid uk-text-center" data-uk-grid-margin>
                                            <div class="uk-width-1-1 uk-align-center">
                                                <div class="uk-grid uk-text-center" data-uk-grid-margin>
                                                    <div class="uk-width-medium-1-1 uk-text-center-medium uk-text-left">
                                                        <input type="submit" value="ثبت" name="submit" class="no-padding md-btn md-btn-primary md-btn-block md-btn-wave-light waves-effect waves-button waves-light box-max-200">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @else
        <div id="page_content_inner">
            <div class="uk-container uk-container-small uk-align-center">
                <div class="uk-grid" data-uk-grid-margin>
                    <div class="uk-width-medium-1-1 uk-align-center">
                        <div class="md-card">
                            <div class="md-card-content">
                                <div class="uk-grid uk-margin-small-bottom" data-uk-grid-margin>
                                    <div class="uk-width-1-1 uk-text-center">
                                            <p> اطلاعاتی موجود نیست</p>
                                    </div>
                                </div>
                                <div class="uk-grid uk-text-center" data-uk-grid-margin="">
                                    <div class="uk-width-1-1 uk-align-center uk-row-first">
                                        <div class="uk-grid uk-text-center" data-uk-grid-margin="">
                                            <div class="uk-width-medium-1-2 uk-text-center-medium uk-text-left uk-row-first">
                                                <a href="/admin/blog/lang/{{ $id }}" class="no-padding md-btn md-btn-primary md-btn-block md-btn-wave-light waves-effect waves-button waves-light box-max-200 waves-input-wrapper">ویرایش</a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    @endif

@endsection