@extends('layouts.admin')

@section('content')
    <div class="uk-grid">
        <div class="uk-width-1-1 uk-text-center uk-margin-small-top uk-margin-small-bottom uk-hidden@l" id="header-mobile">
            زبان ها
        </div>
    </div>
    <div id="page_content_inner">
        <div class="uk-container uk-container-small uk-align-center">
            <div class="uk-grid" data-uk-grid-margin>
                <div class="uk-width-medium-1-1 uk-align-center">
                    <div class="md-card">
                        <div class="md-card-content">
                            <h2 class="heading_b uk-margin-bottom">زبان ها</h2>
                            <div class="uk-grid" data-uk-grid-margin>
                                <div class="uk-width-medium-1-1">
                                    <div class="padding-24">
                                        نکته: برای نمایش بلاگ و اخبار به زبان های مختف بر روی زبان مورد نظر کلیک کرده و محتوای خود را به همان زبان وارد کنید.
                                    </div>
                                </div>
                                <div class="uk-width-medium-1-1">
                                    <div class="padding-24" id="check-language">
                                        @foreach($config_lang as $key => $value)
                                            <span class="icheck-inline">
                                                <a href="/admin/blog/create/{{$id}}/{{$key}}">
                                                    @if(array_search($key , $languages) !== false)
                                                        <input checked type="checkbox" name="default-en" id="checkbox_demo_inline_4" data-md-icheck />
                                                    @else
                                                        <input type="checkbox" name="default-en" id="checkbox_demo_inline_4" data-md-icheck />
                                                    @endif
                                                    <label  class="inline-label">{{$value}}</label>
                                                </a>
                                            </span>
                                        @endforeach
                                    </div>
                                </div>
                            </div>
                            <div class="uk-grid" data-uk-grid-margin>
                                <div class="uk-width-medium-1-1 uk-text-center-small uk-text-right">
                                    <a href="/admin/blog" class="md-btn md-btn-primary md-btn-wave-light waves-effect waves-button waves-light">رد شدن از زبان</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection