@extends('layouts.admin')

@section('content')
    <div class="uk-grid">
        <div class="uk-width-1-1 uk-text-center uk-margin-small-top uk-margin-small-bottom uk-hidden@l" id="header-mobile">
            لیست مطالب
        </div>
    </div>
    <div id="page_content_inner">
        <div class="uk-container uk-align-center">
            <div class="uk-grid" data-uk-grid-match id="slider_lists">
                <div class="uk-width-large-1-1">
                    <div class="md-card uk-margin-medium-bottom">
                        <div class="md-card-content">
                            <h2 class="heading_b uk-margin-bottom">لیست مطالب</h2>
                            <div class="uk-overflow-container">
                                <table id="news-articles" class="uk-table uk-table-hover uk-text-nowrap" cellspacing="0" width="100%">
                                    <thead>
                                    <tr>
                                        <th>عنوان</th>
                                        <th>تاریخ انتشار</th>
                                    </tr>
                                    </thead>
                                    <tfoot>
                                    <tr>
                                        <th>عنوان</th>
                                        <th>تاریخ انتشار</th>
                                    </tr>
                                    </tfoot>
                                    <tbody>
                                    @foreach($blog as $value)
                                        @if(isset($value['title']))
                                            <tr>
                                                <td><a href="/admin/blog/{{$value['id']}}/{{$value['lang']}}">{{$value['title']}}</a></td>
                                                <td>{{ $value['date'] }}</td>
                                            </tr>
                                        @else
                                            <tr>
                                                <td><a href="/admin/blog/{{$value['id']}}/{{App::getLocale()}}"> -- </a></td>
                                                <td> -- </td>
                                            </tr>
                                        @endif
                                    @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('footer')
    <script src="{{ asset('admin/assets/js/datatables.js') }}"></script>
    <script>
        $(document).ready(function() {
            var table = $('#news-articles').DataTable( {
                responsive: true,
                "bLengthChange": false,
                'info' : false,
                "order": [],
                "language": {
                    "search": "جستجو در فهرست",
                    "paginate": {
                        "next": " > ",
                        "previous": " < "
                    }
                },
                "initComplete": function () {
                    var btn = $('#excel-btn');
                    var target =$(document).find('.buttons-excel');
                    btn.on('click', function(event) {
                        console.log('btn');
                        target.triggerHandler('click');
                        event.preventDefault();
                    });
                }
            } );
            table.buttons().container()
                .appendTo( $('.table-buttons', table.table().container() ) );
        } );

    </script>
@endsection