@extends('layouts.admin')

@section('header')
    <link rel="stylesheet" href="{{ asset('admin/assets/css/croppie.css') }}" media="all">
@endsection

@section('content')

    <div class="uk-grid">
        <div class="uk-width-1-1 uk-text-center uk-margin-small-top uk-margin-small-bottom uk-hidden@l" id="header-mobile">
            اخبار و بلاگ
        </div>
    </div>
    <div id="page_content_inner">
        <div class="uk-container uk-container-small uk-align-center">
            <div class="uk-grid" data-uk-grid-margin>
                <div class="uk-width-medium-1-1 uk-align-center">
                    <div class="md-card">
                        <div class="md-card-content">
                            <h2 class="heading_b uk-margin-bottom">ایجاد بلاگ</h2>
                            <form method="post" action="{{route('store_blog')}}" class="uk-form-stacked">
                                @csrf
                                <div class="uk-grid" data-uk-grid-margin>
                                    <div class="uk-width-1-1" id="Div-image">
                                        <label class="heading_a secondary-color">تصویر </label>
                                        <style> #Div-image </style>
                                        <div id="upload-demo" class="max-width-300"></div>
                                        <input type="hidden" id="image-code" name="image" value="">
                                        <input class="Upload_Croper" type="file" id="upload-image">
                                        <div class="uk-width-1-1 uk-margin-small-bottom" dir="ltr"> 650 * 368 </div>
                                        <button type="button" class="md-btn md-btn-primary md-btn-wave-light waves-effect waves-button waves-light Select_photo_croper">ویرایش</button>
                                        <button type="button" class="md-btn md-btn-danger md-btn-wave-light waves-effect waves-button waves-light remove_photo_croper">حذف</button>
                                        <div class="clearfix"><br></div>
                                        @if ($errors->has('image'))
                                            <span class="span-error">
                                                <strong>{{ $errors->first('image') }}</strong>
                                            </span>
                                        @endif
                                    </div>
                                </div>
                                <div class="uk-grid uk-margin-top" data-uk-grid-margin>
                                    <div class="uk-width-medium-1-1 uk-width-large-1-3">
                                        <div class="uk-form-row">
                                            <div class="parsley-row">
                                                <div class="md-input-wrapper">
                                                    <label for="article-title">تیتر اصلی<span class="req">*</span></label>
                                                    <input id="title" type="text" class="md-input{{ $errors->has('title') ? ' md-input-danger' : '' }}" name="title" value="{{ old('title') }}">
                                                    <span class="md-input-bar"></span>
                                                </div>
                                                @if ($errors->has('title'))
                                                    <span class="span-error">
                                                        <strong>{{ $errors->first('title') }}</strong>
                                                    </span>
                                                @endif
                                            </div>
                                        </div>
                                    </div>

                                    <div class="uk-width-medium-1-1 uk-width-large-1-3">
                                        <div class="uk-form-row">
                                            <div class="parsley-row">
                                                <div class="md-input-wrapper">
                                                    <label for="article-subtitle">زیرتیتر<span class="req">*</span></label>
                                                    <input id="sub_title" type="text" class="md-input{{ $errors->has('sub_title') ? ' md-input-danger' : '' }}" name="sub_title" value="{{ old('sub_title') }}">
                                                    <span class="md-input-bar"></span>
                                                </div>
                                                @if ($errors->has('sub_title'))
                                                    <span class="span-error">
                                                        <strong>{{ $errors->first('sub_title') }}</strong>
                                                    </span>
                                                @endif
                                            </div>
                                        </div>
                                    </div>

                                    <div class="uk-width-medium-1-1 uk-width-large-1-3">
                                        <div class="uk-form-row">
                                            <div class="parsley-row">
                                                <div class="md-input-wrapper">
                                                    <label for="article-draft">پیشنویس<span class="req">*</span></label>
                                                    <input id="description" type="text" class="md-input{{ $errors->has('description') ? ' md-input-danger' : '' }}" name="description" value="{{ old('description') }}">
                                                    <span class="md-input-bar"></span>
                                                </div>
                                            </div>
                                            @if ($errors->has('description'))
                                                <span class="span-error">
                                                    <strong>{{ $errors->first('description') }}</strong>
                                                </span>
                                            @endif
                                        </div>
                                    </div>

                                    <div class="uk-width-medium-1-1 uk-width-large-1-3">
                                        <div class="uk-form-row">
                                            <div class="parsley-row">
                                                <div class="md-input-wrapper">
                                                    <label for="article-keywords">کلمات کلیدی<span class="req">*</span></label>
                                                    <input id="keyword" type="text" class="md-input{{ $errors->has('keyword') ? ' md-input-danger' : '' }}" name="keyword" value="{{ old('keyword') }}" >
                                                    <span class="md-input-bar"></span>
                                                </div>
                                                @if ($errors->has('keyword'))
                                                    <span class="span-error" role="alert">
                                                        <strong>{{ $errors->first('keyword') }}</strong>
                                                    </span>
                                                @endif
                                            </div>
                                        </div>
                                    </div>

                                    <div class="uk-width-medium-1-1 uk-width-large-1-3">
                                        <div class="uk-form-row">
                                            <div class="parsley-row">
                                                <div class="md-input-wrapper">
                                                    <label for="meta_description">توضیحات متا<span class="req">*</span></label>
                                                    <input id="meta_description" type="text" class="md-input{{ $errors->has('meta_description') ? ' md-input-danger' : '' }}" name="meta_description" value="{{ old('meta_description') }}" >
                                                    <span class="md-input-bar"></span>
                                                </div>
                                                @if ($errors->has('meta_description'))
                                                    <span class="span-error" role="alert">
                                                        <strong>{{ $errors->first('meta_description') }}</strong>
                                                    </span>
                                                @endif
                                            </div>
                                        </div>
                                    </div>

                                    <div class="uk-width-medium-1-1 uk-width-large-1-1">
                                        <div class="uk-form-row">
                                            <div class="parsley-row">
                                                <img id="holder" style="margin-top:15px;max-height:100px;">
                                                <div class="md-input-wrapper">
                                                    <label for="article-content">متن اصلی</label>
                                                    <div><br><br></div>
                                                    <textarea name="content_text" id="content"></textarea>
                                                    <span class="md-input-bar"></span>
                                                </div>
                                                @if ($errors->has('content_text'))
                                                    <span class="span-error" role="alert">
                                                        <strong>{{ $errors->first('content_text') }}</strong>
                                                    </span>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="uk-grid" data-uk-grid-margin>
                                    <div class="uk-width-medium-1-2">
                                        <div class="uk-grid">
                                            <div class="uk-width-1-1 uk-margin-small-bottom">
                                                <label class="secondary-color">وضعیت انتشار</label>
                                            </div>
                                            <div class="uk-width-1-1">
                                                    <span class="icheck-inline">
                                                        <input type="radio" id="radio_demo_inline_1" checked value="active" name="status" data-md-icheck />
                                                        <label for="radio_demo_inline_1" class="inline-label">فعال</label>
                                                    </span>
                                                <span class="icheck-inline">
                                                        <input type="radio" id="radio_demo_inline_2" value="inactive" name="status" data-md-icheck />
                                                        <label for="radio_demo_inline_2" class="inline-label">غیر فعال</label>
                                                    </span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="uk-grid uk-text-center" data-uk-grid-margin>
                                    <div class="uk-width-1-1 uk-align-center">
                                        <div class="uk-grid uk-text-center" data-uk-grid-margin>
                                            <div class="uk-width-medium-1-1 uk-text-center-medium uk-text-left">
                                               <input type="submit" value="ثبت" name="submit" class="no-padding md-btn md-btn-primary md-btn-block md-btn-wave-light waves-effect waves-button waves-light box-max-200">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('footer')

    <script src="{{ asset('admin/ckeditor/ckeditor.js') }}"></script>
    <script>
        CKEDITOR.replace( 'content', {
            language: 'fa',
            uiColor: '#9AB8F3',
            filebrowserImageBrowseUrl: '/laravel-filemanager?type=Images',
            filebrowserImageUploadUrl: '/laravel-filemanager/upload?type=Images&_token=',
            filebrowserBrowseUrl: '/laravel-filemanager?type=Files',
            filebrowserUploadUrl: '/laravel-filemanager/upload?type=Files&_token='
        });
        $(function() {
            if(isHighDensity()) {
                $.getScript( "{{ asset('admin/bower_components/dense/src/dense.js') }}", function() {
                    // enable hires images
                    altair_helpers.retina_images();
                });
            }
            if(Modernizr.touch) {
                // fastClick (touch devices)
                FastClick.attach(document.body);
            }
        });
        $window.load(function() {
            // ie fixes
            altair_helpers.ie_fix();
        });
    </script>

    <script>
        // load parsley config (altair_admin_common.js)
        altair_forms.parsley_validation_config();
    </script>

    <!--  forms validation functions -->
    <script src="{{ asset('admin/assets/js/pages/forms_validation.min.js') }}"></script>

    <!--  dropify -->
    <script src="{{ asset('admin/assets/js/custom/dropify/dist/js/dropify.min.js') }}"></script>

    <!--  form file input functions -->
    <script src="{{ asset('admin/assets/js/pages/forms_file_input.min.js') }}"></script>

    <!-- Croppie -->
    <script src="{{ asset('admin/assets/js/croppie.js') }}"></script>

    <script type="text/javascript">

        //start image 1
        $uploadCrop = $('#upload-demo').croppie({
            enableExif: true,
            viewport: {
                width: 300,
                height: 170,
                type: 'square'
            },
            boundary: {
                width: 300,
                height: 170
            }
        });

        $('#upload-image').on('change', function () {
            var Id = $(this).parent().attr('id');
            $('#'+Id+' .cr-viewport').css('background-image' , 'none');
            var reader = new FileReader();
            reader.onload = function (e) {
                $uploadCrop.croppie('bind', {
                    url: e.target.result
                }).then(function(){
                    GetCode();
                });
            }
            reader.readAsDataURL(this.files[0]);
        });

        function GetCode() {
            $uploadCrop.croppie('result', {
                type: 'canvas',
                size: {
                    width: 850,
                    height: 481
                },
                format: "jpeg",
                quality: '0.7'
            }).then(function (resp) {
                $('#image-code').val(resp);
            });
        }

        $('.Select_photo_croper').click(function () {
            $('#upload-image').trigger('click');
        });

        $('.remove_photo_croper').on('click', function() {
            $('.cr-viewport').css('background-image' , 'none');
            $('.cr-image').attr('src', '');
            $('#upload-image').val('');
            $('#image-code').val('delete');
        });

        $('.cr-overlay').mouseup(function () {
            GetCode();
        });

        $('.cr-overlay').bind('mousewheel', function(e){
            GetCode();
        });
    </script>
@endsection
