@extends('layouts.admin')

@section('header')
    <link rel="stylesheet" href="{{ asset('admin/assets/css/datatables.css') }}" media="all">
@endsection

@section('content')

    <div class="uk-grid">
        <div class="uk-width-1-1 uk-text-center uk-margin-small-top uk-margin-small-bottom uk-hidden@l" id="header-mobile">
            صورت حساب ها
        </div>
    </div>
    <div id="page_content_inner">
        <div class="uk-container uk-align-center">
            <div class="uk-grid" data-uk-grid-match id="bill_lists">
                <div class="uk-width-large-1-1">
                    <div class="md-card uk-margin-medium-bottom">
                        <div class="md-card-content">
                            <h2 class="heading_b uk-margin-bottom">صورتحساب ها</h2>
                            <form method="get" action="">
                                <div class="uk-grid" data-uk-grid-margin style="margin-bottom: 50px">
                                    <div class="uk-width-medium-1-5">
                                        <div class="uk-form-row">
                                            <div class="parsley-row">
                                                <div class="md-input-wrapper">
                                                    <label for="user-cellphone">نام</label>
                                                    <input type="text" name="name" value="{{key_exists("name",$search)?$search['name']:null}}"  class="md-input input-search">
                                                    <span class="md-input-bar"></span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="uk-width-medium-1-5">
                                        <div class="uk-form-row">
                                            <div class="parsley-row">
                                                <div class="md-input-wrapper">
                                                    <label for="user-cellphone">شماره موبایل</label>
                                                    <input type="text"  name="mobile_number" value="{{key_exists("mobile_number",$search)?$search['mobile_number']:null}}"  class="md-input input-search">
                                                    <span class="md-input-bar"></span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="uk-width-medium-1-5">
                                        <div class="uk-form-row">
                                            <div class="parsley-row">
                                                <div class="md-input-wrapper">
                                                    <label for="user-cellphone">شماره موبایل</label>
                                                    <input type="text"  name="order" value="{{key_exists("order",$search)?$search['order']:null}}" class="md-input input-search">
                                                    <span class="md-input-bar"></span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <input type="submit" value="جستجو" class="button-search">
                            </form>
                            <div class="uk-overflow-container">
                                <table id="bills-lists" class="uk-table uk-table-hover uk-text-nowrap" cellspacing="0" width="100%">
                                    <thead>
                                    <tr>
                                        <th>پرداخت کننده</th>
                                        <th>دوره</th>
                                        <th>تاریخ</th>
                                        <th>مبلغ(ریال)</th>
                                    </tr>
                                    </thead>
                                    <tfoot>
                                    <tr>
                                        <th>پرداخت کننده</th>
                                        <th>دوره</th>
                                        <th>تاریخ</th>
                                        <th>مبلغ(ریال)</th>
                                    </tr>
                                    </tfoot>
                                    <tbody>
                                    @foreach($invoices as $invoice)

                                        <tr>
                                            <td><a href="{{route("user_invoice",[$invoice->order_id])}}">{{$invoice->user_name." ".$invoice->user_family}}</a></td>
                                            <td><a href="{{route("user_invoice",[$invoice->order_id])}}">{{$invoice->user_mobilenumber}}</a></td>
                                            <td><a href="{{route("user_invoice",[$invoice->order_id])}}">{{\App\Traits\Date::toJalali($invoice->order_date)}}</a></td>
                                            <td><a href="{{route("user_invoice",[$invoice->order_id])}}">{{number_format(intval($invoice->order_amount))}}</a></td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                </table>
                                <div class="table-buttons">
                                    <div>
                                        {{$invoices->links()}}
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection

@section('footer')
    {{--<script src="{{ asset('admin/assets/js/datatables.js') }}"></script>--}}
    {{--<script>--}}
        {{--$(document).ready(function() {--}}
            {{--var table = $('#bills-lists').DataTable( {--}}
                {{--responsive: true,--}}
                {{--"bLengthChange": false,--}}
                {{--'info' : false,--}}
                {{--"order": [],--}}
                {{--"language": {--}}
                    {{--"search": "جستجو در فهرست",--}}
                    {{--"paginate": {--}}
                        {{--"next": " > ",--}}
                        {{--"previous": " < "--}}
                    {{--}--}}
                {{--},--}}
                {{--"initComplete": function () {--}}
                    {{--var btn = $('#excel-btn');--}}
                    {{--var target =$(document).find('.buttons-excel');--}}
                    {{--btn.on('click', function(event) {--}}
                        {{--console.log('btn');--}}
                        {{--target.triggerHandler('click');--}}
                        {{--event.preventDefault();--}}
                    {{--});--}}
                {{--}--}}
            {{--} );--}}
            {{--table.buttons().container()--}}
                {{--.appendTo( $('.table-buttons', table.table().container() ) );--}}
        {{--} );--}}

    {{--</script>--}}
@endsection