<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateLicenseTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        
        Schema::create('licenses', function (Blueprint $table) {
            $table->increments('id');
            $table->string('code')->unique();
            $table->string('prefixdomain')->nullable();
            $table->string('domain')->nullable();
            $table->string('suffixdomain')->default('ir');
            $table->string('host');
            $table->boolean('has_domain')->default(0);
            $table->timestamp('expire_date')->nullable();
            $table->integer('private_balance')->default(0);
            $table->integer('halfprivate_balance')->default(0);
            $table->integer('public_balance')->default(0);
            $table->integer('sms_balance')->default(0);
            $table->boolean('iscompleted')->default(false);
            $table->boolean('status')->default(true);
            $table->integer('user_id');
            $table->string('nic_id')->nullable();
            $table->string('email')->nullable();
            $table->timestamps();
        });

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('licenses');
    }
}
