<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddColToUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('users', function (Blueprint $table) {
            $table->string('address')->nullable();
            $table->string('city')->nullable();
            $table->string('state')->nullable();
            $table->decimal('longitude', 8, 6)->nullable();
            $table->decimal('latitude', 8, 6)->nullable();
            $table->date('birthday')->nullable();
            $table->smallInteger('status')->default(1);
            $table->enum('gender', ['male', 'female','other'])->default('male');
            $table->string('mobile_number')->unique()->nullable();
            $table->string('username')->unique()->nullable();
            $table->string('country')->nullable();
            $table->string('national_code')->nullable();
            $table->string('which_apps')->nullable();
            $table->string('unique_id')->nullable();
            $table->string('image_url')->nullable();
            $table->string('tel_number')->nullable();
            $table->string('zip_code')->nullable();
            $table->string('account_number')->nullable();
            $table->string('avatar')->nullable();
            $table->string('email')->nullable()->change();
            $table->string('password')->nullable()->change();
            $table->string('name')->nullable()->change();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn('address');
            $table->dropColumn('city');
            $table->dropColumn('state');
            $table->dropColumn('longitude');
            $table->dropColumn('latitude');
            $table->dropColumn('birthday');
            $table->dropColumn('status');
            $table->dropColumn('gender');
            $table->dropColumn('mobile_number');
            $table->dropColumn('username');
            $table->dropColumn('country');
            $table->dropColumn('national_code');
            $table->dropColumn('which_apps');
            $table->dropColumn('unique_id');
            $table->dropColumn('image_url');
            $table->dropColumn('tel_number');
            $table->dropColumn('zip_code');
            $table->dropColumn('account_number');
            $table->dropColumn('avatar');
        });
    }
}
