<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateLiveMeeting extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('live_meeting', function (Blueprint $table) {
            $table->increments('id');
            $table->string('meetingID' , 250)->unique();
            $table->string('internalMeetingID' , 250);
            $table->string('parentMeetingID' , 250);
            $table->string('attendeePW' , 250);
            $table->string('moderatorPW' , 250);
            $table->string('createTime' , 250);
            $table->string('voiceBridge' , 250);
            $table->string('dialNumber' , 250);
            $table->string('createDate' , 250);
            $table->string('hasUserJoined' , 250);
            $table->string('duration' , 250);
            $table->string('hasBeenForciblyEnded' , 250);
            $table->string('messageKey' , 250)->nullable();
            $table->string('message' , 250)->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
    }
}
