<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateProductsStore extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('products_store', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('pid');
            $table->integer('parent')->nullable();
            $table->string('name' , 40);
            $table->string('code' , 40);
            $table->string('type' , 40);
            $table->double('price' , 40);
            $table->double('tax' , 40);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('products_store');
    }
}
