<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateBlogsTranslate extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('blogs_translate', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('blog_id')->unsigned()->nullable();
            $table->string('image' , 300)->nullable();
            $table->string('title' , 300)->collation('utf8_general_ci');
            $table->text('sub_title')->collation('utf8_general_ci');
            $table->string('keyword' , 1000);
            $table->string('description' , 1000)->collation('utf8_general_ci');
            $table->text('content')->collation('utf8_general_ci');
            $table->string('lang' , 10);
            $table->integer('visit')->default(0);
            $table->timestamps();
            $table->foreign('blog_id')->references('id')->on('blogs')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('blogs_translate');
    }
}
