<?php

namespace App;

use App\Model\License;
use Illuminate\Notifications\Notifiable;
use Laravel\Passport\HasApiTokens;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Spatie\Permission\Traits\HasRoles;

class User extends Authenticatable
{
    use HasRoles;
    use HasApiTokens,Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $guarded = [
        'id'
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];


    const AVATAR_DIRECTORY = "/media/images/avatar/";

    public function Licenses(){
        return $this->hasMany(License::class);
    }


    public function findForPassport($username){
        return $this->where('mobile_number', $username)->first();
    }

    public function validateForPassportPasswordGrant($password)
    {
        return !strcmp($password, $this->getAuthPassword());
    }
}
