<?php
/**
 * Created by PhpStorm.
 * User: ladan
 * Date: 9/9/2018
 * Time: 13:09
 */

namespace App\Traits;

use GuzzleHttp\Client;

trait Wallet
{
    static function balance($user_id){
        $access_token = Oauth::getAccessToken()->data->access_token->access_token;
        $headers = [
            'Accept' => 'application/json',
            'Content-Type' => 'application/x-www-form-urlencoded',
            'Authorization' => 'Bearer '.$access_token
        ];
        $query = [
            'parameters' =>'["mobile_number","gender","name","lastname","birthday","national_code","email"]'
        ];
        $client = new Client();
        try {
            $res = $client->get(config('global.base_api').'/user/'.$user_id, [
                'headers' => $headers ,
                'query' => $query ,
            ]);
            $response =  json_encode(['error' => null , 'code' => $res->getStatusCode() , 'body' => json_decode($res->getBody()->getContents())]);
        } catch (RequestException $e) {
            if ($e->hasResponse()) {
                $response = json_encode(['error' => $e->getResponse()->getReasonPhrase() , 'code' => $e->getCode() , 'body' => null]);
            }else
                $response =json_encode(['error' => $e->getMessage() , 'code' => $e->getCode() , 'body' => null]);
        }
        $response = json_decode($response);
        session()->put('user_information', $response->body->data);
        return $response;
    }
    static function charge($amount , $currency , $user_token){
        $access_token = Oauth::getAccessToken()->data->access_token->access_token;
        $headers = [
            'Accept' => 'application/json',
            'Content-Type' => 'application/x-www-form-urlencoded',
            'Authorization' => 'Bearer '.$access_token
        ];
        $client = new Client();
        try {
            $res = $client->post(config('global.base_api').'/user/wallet', [
                'headers' => $headers ,
                'form_params' => [ 'access_token' => $user_token , 'amount' => $amount , 'currency' => $currency ]
            ]);
            $response =  json_encode(['error' => null , 'code' => $res->getStatusCode() , 'body' => json_decode($res->getBody()->getContents())]);
        } catch (RequestException $e) {
            if ($e->hasResponse()) {
                $response = json_encode(['error' => $e->getResponse()->getReasonPhrase() , 'code' => $e->getCode() , 'body' => null]);
            }else
                $response =json_encode(['error' => $e->getMessage() , 'code' => $e->getCode() , 'body' => null]);
        }
        return json_decode($response);
    }
}