<?php
/**
 * Created by PhpStorm.
 * User: ladan
 * Date: 9/9/2018
 * Time: 14:45
 */

namespace App\Traits;

use App\Model\ProductsStore;
use GuzzleHttp\Client;
use GuzzleHttp\Exception\RequestException;
use Illuminate\Http\Request;
use Symfony\Component\HttpKernel\Exception\HttpException;

trait Shop
{
    static function products($id, $currency)
    {
        $access_token = Oauth::getAccessToken()->data->access_token->access_token;
        $headers = [
            'Accept' => 'application/json',
            'Authorization' => 'Bearer ' . $access_token
        ];
        $client = new Client();
        try {
            $res = $client->get(config('global.aimeos_api') . '/product', [
                'headers' => $headers,
                'query' => ['id' => $id, 'include' => 'attribute,price,product', 'currency' => $currency]
            ]);
            $response = json_encode(['error' => null, 'code' => $res->getStatusCode(), 'body' => json_decode($res->getBody()->getContents())]);
        } catch (RequestException $e) {
            if ($e->hasResponse()) {
                $response = json_encode(['error' => $e->getResponse()->getReasonPhrase(), 'code' => $e->getCode(), 'body' => null]);
            } else
                $response = json_encode(['error' => $e->getMessage(), 'code' => $e->getCode(), 'body' => null]);
        }
        return json_decode($response);
    }

    static function invoices(Request $request)
    {
        $queryString = $request->getQueryString();
        $access_token = Oauth::getAccessToken()->data->access_token->access_token;
        $client = new Client;
        $URI = config('global.base_api') . '/order?' . $queryString;
        $params['headers'] = ['Accept' => 'application/json', 'Content-Type' => 'application/x-www-form-urlencoded', 'Authorization' => 'Bearer ' . $access_token];
        try {
            $res = $client->get($URI, $params);
            $response = $res->getBody()->getContents();
        } catch (RequestException $e) {
            if ($e->hasResponse()) {
                $response = json_encode(['error' => $e->getResponse()->getReasonPhrase(), 'code' => $e->getCode(), 'body' => null]);
            } else
                $response = json_encode(['error' => $e->getMessage(), 'code' => $e->getCode(), 'body' => null]);
        }
        return Oauth::paginate(json_decode($response), $request);
    }

    static function product($id, $currency)
    {
        $client = new Client;
        try {
            $res = $client->request('GET', config('global.aimeos_api') . '/product', ['query' => 'id=' . $id . '&include=attribute,media,price,product,product/property,text&currency=' . $currency]);
            $response = json_encode(['error' => null, 'code' => $res->getStatusCode(), 'body' => json_decode($res->getBody()->getContents())]);
        } catch (RequestException $e) {
            if ($e->hasResponse()) {
                $response = json_encode(['error' => $e->getResponse()->getReasonPhrase(), 'code' => $e->getCode(), 'body' => null]);
            } else
                $response = json_encode(['error' => $e->getMessage(), 'code' => $e->getCode(), 'body' => null]);
        }
        return json_decode($response);
    }

    static function basket($currency, $token = null)
    {
        $access_token = Oauth::getAccessToken()->data->access_token->access_token;
        $headers = [
            'Accept' => 'application/json',
            'Authorization' => 'Bearer ' . $access_token
        ];
        $query = [
            "currency" => $currency,
            "_token" => $token
        ];
        $client = new Client();
        try {
            $res = $client->get(config('global.aimeos_api') . '/basket', [
                'query' => $query,
                'headers' => $headers
            ]);
            $response = json_encode(['error' => null, 'code' => $res->getStatusCode(), 'body' => json_decode($res->getBody()->getContents())]);
        } catch (RequestException $e) {
            if ($e->hasResponse()) {
                $response = json_encode(['error' => $e->getResponse()->getReasonPhrase(), 'code' => $e->getCode(), 'body' => null]);
            } else
                $response = json_encode(['error' => $e->getMessage(), 'code' => $e->getCode(), 'body' => null]);
        }
        return json_decode($response);
    }

    static function add_to_basket($token, $id, $quantity, $currency, $config = null, $custom = null)
    {
        $access_token = Oauth::getAccessToken()->data->access_token->access_token;
        $headers = [
            'Accept' => "application/json",
            'Content-Type' => "application/json",
            'Authorization' => 'Bearer ' . $access_token,
        ];
        $test = [
            'data' => [
                'attributes' => [
                    'product.id' => $id,
                    'quantity' => $quantity,
                    'stocktype' => 'default',
                    'config' => $config,
                    'custom' => $custom
                ]
            ]
        ];
        $query = [
            "id" => "default",
            "related" => "product",
            "currency" => $currency,
            "_token" => $token
        ];

        $client = new Client();

        try {
            $res = $client->post(config('global.aimeos_api') . '/basket', [
                'query' => $query,
                'headers' => $headers,
                'json' => $test,
                'http_errors' => false
            ]);
            $response = json_encode(['error' => null, 'code' => $res->getStatusCode(), 'body' => json_decode($res->getBody()->getContents())]);
        } catch (RequestException $e) {
            if ($e->hasResponse()) {
                $response = json_encode(['error' => $e->getResponse()->getReasonPhrase(), 'code' => $e->getCode(), 'body' => null]);
            } else
                $response = json_encode(['error' => $e->getMessage(), 'code' => $e->getCode(), 'body' => null]);
        }
        return json_decode($response);

    }

    static function delete_product($token, $currency, $id)
    {
        $access_token = Oauth::getAccessToken()->data->access_token->access_token;
        $headers = [
            'Authorization' => "Bearer " . $access_token,
            'Accept' => 'application/json',
        ];
        $query = [
            "id" => "default",
            "related" => "product",
            "relatedid" => $id,
            "currency" => $currency,
            "_token" => $token
        ];
        $client = new Client();
        try {
            $res = $client->post(config('global.aimeos_api') . '/basket', [
                'query' => $query,
                'headers' => $headers,
                'form_params' => [
                    '_method' => 'DELETE'
                ]
            ]);
            $response = json_encode(['error' => null, 'code' => $res->getStatusCode(), 'body' => json_decode($res->getBody()->getContents())]);
        } catch (RequestException $e) {
            if ($e->hasResponse()) {
                $response = json_encode(['error' => $e->getResponse()->getReasonPhrase(), 'code' => $e->getCode(), 'body' => null]);
            } else
                $response = json_encode(['error' => $e->getMessage(), 'code' => $e->getCode(), 'body' => null]);
        }
        return json_decode($response);
    }

    static function discount($user_token , $currency, $token, $discount)
    {
        $access_token = Oauth::getAccessToken()->data->access_token->access_token;
        $headers = [
            'Authorization' => "Bearer " . $access_token,
            'Content-Type' => 'application/json',
            'Accept' => 'application/json'
        ];
        $query = [
            "id" => "default",
            "related" => "coupon",
            "currency" => $currency,
            "_token" => $token
        ];
        $body = [
            'data' => [
                'id' => $discount,
                'access_token' => $user_token
            ]
        ];
        $client = new Client();
        try {
            $res = $client->post(config('global.aimeos_api') . '/basket', [
                'query' => $query,
                'headers' => $headers,
                'json' => $body,
                'http_errors' => false
            ]);
            $response = json_encode(['error' => null, 'code' => $res->getStatusCode(), 'body' => json_decode($res->getBody()->getContents()), 'header' => $res->getHeader('discount')]);
        } catch (RequestException $e) {
            if ($e->hasResponse()) {
                $response = json_encode(['error' => $e->getResponse()->getReasonPhrase(), 'code' => $e->getCode(), 'body' => null]);
            } else
                $response = json_encode(['error' => $e->getMessage(), 'code' => $e->getCode(), 'body' => null]);
        }
        return json_decode($response);
    }

    static function add_address($token , $mobile)
    {
        $access_token = Oauth::getAccessToken()->data->access_token->access_token;
        $headers = [
            'Authorization' => "Bearer " . $access_token,
            'Content-Type' => 'application/json',
            'Accept' => 'application/json'
        ];
        $query = [
            "id" => "default",
            "related" => "address",
            "_token" => $token
        ];
        $body = [
            'data' => [
                'id' => 'payment',
                'attributes' => [
                    'order.base.address.email' => $mobile . '@yekita.com',
                ]
            ]
        ];
        $client = new Client();
        try {
            $res = $client->post(config('global.aimeos_api') . '/basket', [
                'query' => $query,
                'headers' => $headers,
                'json' => $body,
            ]);
            $response = json_encode(['error' => null, 'code' => $res->getStatusCode(), 'body' => json_decode($res->getBody()->getContents()), 'header' => $res->getHeader('discount')]);
        } catch (RequestException $e) {
            if ($e->hasResponse()) {
                $response = json_encode(['error' => $e->getResponse()->getReasonPhrase(), 'code' => $e->getCode(), 'body' => null]);
            } else
                $response = json_encode(['error' => $e->getMessage(), 'code' => $e->getCode(), 'body' => null]);
        }
        return json_decode($response);
    }

    static function delete_discount($currency, $token, $discount)
    {
        $access_token = Oauth::getAccessToken()->data->access_token->access_token;
        $headers = [
            'Authorization' => "Bearer " . $access_token,
            'Content-Type' => 'application/json',
            'Accept' => 'application/json'
        ];
        $query = [
            "id" => "default",
            "related" => "coupon",
            "currency" => $currency,
            "_token" => $token
        ];
        $body = [
            'data' => [
                'id' => $discount
            ],
            '_method' => 'DELETE'
        ];
        $client = new Client();
        try {
            $res = $client->post(config('global.aimeos_api') . '/basket', [
                'query' => $query,
                'headers' => $headers,
                'json' => $body
            ]);
            $response = json_encode(['error' => null, 'code' => $res->getStatusCode(), 'body' => json_decode($res->getBody()->getContents())]);
        } catch (RequestException $e) {
            if ($e->hasResponse()) {
                $response = json_encode(['error' => $e->getResponse()->getReasonPhrase(), 'code' => $e->getCode(), 'body' => null]);
            } else
                $response = json_encode(['error' => $e->getMessage(), 'code' => $e->getCode(), 'body' => null]);
        }
        return json_decode($response);

    }

    static function basket_save($user_token , $currency , $token)
    {
        $access_token = Oauth::getAccessToken()->data->access_token->access_token;
        $headers = [
            'Authorization' => "Bearer " . $access_token,
            'Accept' => 'application/json'
        ];
        $query = [
            "currency" => $currency,
            "_token" => $token
        ];
        $client = new Client();
        try {
            $res = $client->post(config('global.aimeos_api') . '/basket', [
                'query' => $query,
                'headers' => $headers,
                'form_params' => ['access_token' => $user_token],
            ]);
            $response = json_encode(['error' => null, 'code' => $res->getStatusCode(), 'body' => json_decode($res->getBody()->getContents())]);
        } catch (RequestException $e) {
            if ($e->hasResponse()) {
                $response = json_encode(['error' => $e->getResponse()->getReasonPhrase(), 'code' => $e->getCode(), 'body' => null]);
            } else
                $response = json_encode(['error' => $e->getMessage(), 'code' => $e->getCode(), 'body' => null]);
        }
        return json_decode($response);
    }

    static function create_invoice($user_token ,$currency, $token, $id)
    {
        $access_token = Oauth::getAccessToken()->data->access_token->access_token;
        $headers = [
            'Authorization' => "Bearer " . $access_token,
            'Accept' => 'application/json'
        ];
        $query = [
            "currency" => $currency,
            "_token" => $token
        ];
        $body = [
            "data" => [
                "attributes" => [
                    "order.baseid" => $id
                ],
                "access_token" => $user_token
            ]
        ];
        $client = new Client();
        try {
            $res = $client->post(config('global.aimeos_api') . '/order', [
                'query' => $query,
                'headers' => $headers,
                'json' => $body
            ]);
            $response = json_encode(['error' => null, 'code' => $res->getStatusCode(), 'body' => json_decode($res->getBody()->getContents()), 'header' => $res->getHeader('license')[0]]);
        } catch (RequestException $e) {
            if ($e->hasResponse()) {
                $response = json_encode(['error' => $e->getResponse()->getReasonPhrase(), 'code' => $e->getCode(), 'body' => null]);
            } else
                $response = json_encode(['error' => $e->getMessage(), 'code' => $e->getCode(), 'body' => null]);
        }
        return json_decode($response);
    }

    static function parse_product_json()
    {
        $products = self::getProductIDs();
        $data = array_dot($products->body->data);
        foreach ($data as $val)
            self::storeProductIds($val->id);
    }
    static function storeProductIds($id){
        $product = self::products($id , 'IRR')->body;
        $data            = array_dot($product->data->attributes);
        $price_id        = $product->data->relationships->price->data[0]->id;
        $included        = array_dot($product->included);
        $price           = array_dot(collect($included)->where("id" , $price_id)->where("type" , 'price')->first()->attributes);
        $ProductStore = ProductsStore::firstOrNew(array('code' => $data['product.code']));
        $ProductStore->pid      = $data['product.id'];
        $ProductStore->code     = $data['product.code'];
        $ProductStore->name     = $data['product.label'];
        $ProductStore->type     = $price['price.domain'];
        $ProductStore->price    = $price['price.value'];
        $ProductStore->tax      = $price['price.taxvalue'];
        $ProductStore->save();

        $attributes = $product->data->relationships->attribute->data;
        foreach ($attributes as $value){
            $attribute           = array_dot(collect($included)->where("id" , $value->id)->where("type" , 'attribute')->first());
            $price_id            = $attribute['relationships']->price->data[0]->id;
            $price               = array_dot(collect($included)->where("id" , $price_id)->where("type" , 'price')->first()->attributes);
            $data                = array_dot($attribute['attributes']);

            $ProductStore = ProductsStore::firstOrNew(array('code' => $data['attribute.code']));
            $ProductStore->pid      = $data['attribute.id'];
            $ProductStore->code     = $data['attribute.code'];
            $ProductStore->name     = $data['attribute.label'];
            $ProductStore->type     = $data['attribute.type'];
            $ProductStore->price    = $price['price.value'];
            $ProductStore->tax      = $price['price.taxvalue'];
            $ProductStore->save();
        }
    }
    static function getProductIDs()
    {
        $access_token = Oauth::getAccessToken()->data->access_token->access_token;
        $headers = [
            'Accept' => 'application/json',
            'Authorization' => 'Bearer ' . $access_token
        ];
        $client = new Client();
        try {
            $res = $client->get(config('global.aimeos_api') . '/product', [
                'headers' => $headers,
                'query' => []
            ]);
            $response = json_encode(['error' => null, 'code' => $res->getStatusCode(), 'body' => json_decode($res->getBody()->getContents())]);
        } catch (RequestException $e) {
            if ($e->hasResponse()) {
                $response = json_encode(['error' => $e->getResponse()->getReasonPhrase(), 'code' => $e->getCode(), 'body' => null]);
            } else
                $response = json_encode(['error' => $e->getMessage(), 'code' => $e->getCode(), 'body' => null]);
        }
        return json_decode($response);
    }
}