<?php
/**
 * Created by PhpStorm.
 * User: ladan
 * Date: 9/3/2018
 * Time: 8:26
 */

namespace App\Traits;

use App\Http\Resources\User\UserResourceApi;
use App\User;
use GuzzleHttp\Client;
use GuzzleHttp\Exception\RequestException;
use Illuminate\Http\Request;
use Illuminate\Pagination\LengthAwarePaginator;
use Illuminate\Support\Facades\Cache;
use Illuminate\Container\Container;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Laravel\Passport\TokenRepository;
use Lcobucci\JWT\Parser;
use Illuminate\Support\Facades\URL;
use Illuminate\Http\Response;

trait Oauth
{
    static function getAccessToken(){
        if(Cache::store('database')->has('access_token_app')){
            $response = Cache::store('database')->get('access_token_app');
        }else{

            $client = new Client;
            $URI = config('global.base_api').'/app/token';

            $params['headers'] = ['Accept' => 'application/json' , 'Content-Type' => 'application/x-www-form-urlencoded'];
            $params['form_params'] = array('client_id' => config('global.client_id'), 'client_secret' => config('global.client_secret'));
            try{
                $res = $client->post( $URI, $params );

                $response =  $res->getBody()->getContents();
                Cache::store('database')->put('access_token_app' , $response , (1440 * 30));

            } catch (RequestException $e) {

            if ($e->hasResponse()) {
                $response = json_encode(['error' => $e->getResponse()->getReasonPhrase() , 'code' => $e->getCode() , 'body' => null]);
            }else
                $response =json_encode(['error' => $e->getMessage() , 'code' => $e->getCode() , 'body' => null]);
        }

        }
        return json_decode($response);
    }

    static function getUserToken($mobile){
        $parameters = array('mobile_number' , 'name' , 'last_name' ,'email');
        $phoneNumber = $mobile;
        $client_id = config("global.client_id");
        $client_secret = config("global.client_secret");
        $user = User::where('mobile_number', $phoneNumber)->first();
        $password = optional($user)->password ?? bcrypt(uniqid());
        if (!$user) {

            $user = new User();
            $user->mobile_number = $phoneNumber;
            $user->password = $password;
            $user->unique_id = uniqid();
            $clientName = self::whichApp(request()->bearerToken());
            $user->which_apps = $clientName;
            $user->save();
//            $user = User::find($user->id);
        }
        $userRegisteredFromWhichApps = $user->which_apps;
        $clientName = self::whichApp(request()->bearerToken());
        if (!strpos($userRegisteredFromWhichApps, $clientName) and strpos($userRegisteredFromWhichApps, $clientName) !== 0) {
            $userRegisteredFromWhichApps = $userRegisteredFromWhichApps . $clientName;
            $user->which_apps = $userRegisteredFromWhichApps;
            $user->save();
        }
        
        $response = self::_getAccessToken($phoneNumber, $user->password, $client_id, $client_secret);
        $guzzleresult = json_decode((string)$response->getBody(), true);
        $result = [];
        $result['token_type'] = $guzzleresult['token_type'];
        $result['expires_in'] = $guzzleresult['expires_in'];
        $result['access_token'] = $guzzleresult['access_token'];
        $result['refresh_token'] = $guzzleresult['refresh_token'];

        return response()->json(['body' => ['data' => ['user' => new UserResourceApi($user, $parameters), 'access_token' => $result]] , 'code' => 200])->setStatusCode(200);

    }

    static function getUserTokenWithPassword($mobile , $password){
        
    }

    public static function whichApp($bearerToken)
    {
        $tokenRepository = new TokenRepository();
        $jwt = (new Parser())->parse($bearerToken);
        $token = $tokenRepository->find($jwt->getClaim('jti'));
        $client = new  \Laravel\Passport\Client();
        $client = $client->find($token->client_id);

        return $client->name;
    }

    public static function _getAccessToken($phoneNumber, $password, $client_id, $client_secret)
    {
        $http = new Client();
        $response = $http->post(URL::to('/oauth/token'), [
            'form_params' => [
                'grant_type' => 'password',
                'client_id' => $client_id,
                'client_secret' => $client_secret,
                'username' => $phoneNumber,
                'password' => $password,
                'scope' => '',
            ],
        ]);

        return $response;

    }


    static function tokenValidate($token){
        $config_parameter = json_encode(array('mobile_number' , 'name' , 'lastname' ,'email'));
        $access_token = self::getAccessToken()->data->access_token->access_token;
        $client = new Client;
        $URI = config('global.base_api').'/user/token/validate';
        $params['headers'] = ['Accept' => 'application/json' , 'Content-Type' => 'application/x-www-form-urlencoded' , 'Authorization' => 'Bearer '.$access_token];
        $params['form_params'] = array('access_token' => $token , 'parameters' => $config_parameter);
        try{
            $res = $client->post( $URI, $params );
            $response =  json_encode(['error' => null , 'code' => $res->getStatusCode() , 'body' => json_decode($res->getBody()->getContents())]);
        }catch (RequestException $e) {
            if ($e->hasResponse()) {
                $response = json_encode(['error' => $e->getResponse()->getReasonPhrase() , 'code' => $e->getCode() , 'body' => null]);
            }else
                $response =json_encode(['error' => $e->getMessage() , 'code' => $e->getCode() , 'body' => null]);
        }

        return json_decode($response);
    }

    static function updateUser($user_id , $avatar = null , $name , $lastname , $gender , $birthday = null , $email = null , $national_code = null , $password = null , $country = null , $state = null , $city = null ,  $tel_number = null , $address = null ){
    
        if(empty($country)){
            $country = 1;
        }
        if(empty($state)){
            $state = 8;
        }
        if(empty($city)){
            $city = 87;
        }
        if(empty($address)){
            $address = '-';
        }


        $user = User::findOrFail($user_id);

        $data = array('name' => $name , 'last_name' => $lastname , 'gender' => $gender  , 'birthday' => $birthday , 'national_code' => $national_code , 'country' => $country , 'state' => $state , 'city' => $city  , 'tel_number' => $tel_number , 'address' => $address , '_method' => 'PUT');        
        if(!is_null($avatar)){
            $avatar = str_replace('data:image/jpeg;base64,' , '' , $avatar);
            $data['avatar'] = $avatar;
        }
        if(!is_null($email)){
            $data['email'] = $email;
        }

        $user->update($data);
        return json_encode(['error' => '' , 'code' => 200 , 'body' => ['data' => $user]]);
    }

    static function updatePassword($user_id , $password){
        $config_parameter = json_encode(array('mobile_number' , 'name' , 'lastname' ,'email'));
        /* $access_token = self::getAccessToken()->data->access_token->access_token;
        $client = new Client;
        $URI = config('global.base_api').'/user/'.$user_id;
        $params['headers'] = [ 'Accept' => 'application/json' , 'Content-Type' => 'application/x-www-form-urlencoded' , 'Authorization' => 'Bearer '.$access_token];
        $params['form_params'] = array('password' => $password); */
        try
        {
            $res = $client->post( $URI, $params );
            $response =  json_encode(['error' => '' , 'code' => $res->getStatusCode() , 'body' => json_decode($res->getBody()->getContents())]);
        }catch (RequestException $e) {

            if ($e->hasResponse()) {

                $response = json_encode(['error' =>$e->getResponse()->getBody()->getContents() , 'code' => $e->getCode() , 'body' => null]);
            }else
                $response =json_encode(['error' => $e->getResponse()->getBody()->getContents() , 'code' => $e->getCode() , 'body' => null]);
        }
        return json_decode($response);
    }

    /**
     * @param Request $request
     * @return mixed
     */
    static function listUser(Request $request){
        $access_token = self::getAccessToken()->data->access_token->access_token;
        $queryString = $request->getQueryString();
        $client = new Client;
        $URI = config('global.base_api').'/user/?'.$queryString;
        $params['headers'] = ['Accept' => 'application/json' , 'Content-Type' => 'application/x-www-form-urlencoded' , 'Authorization' => 'Bearer '.$access_token];
        try{
            $res = $client->get( $URI, $params );
            $response =  $res->getBody()->getContents();
        }catch (RequestException $e) {
            if ($e->hasResponse()) {
                $response = json_encode(['error' => $e->getResponse()->getReasonPhrase() , 'code' => $e->getCode() , 'body' => null]);
            }else
                $response =json_encode(['error' => $e->getMessage() , 'code' => $e->getCode() , 'body' => null]);
        }
        return Oauth::paginate(json_decode($response),$request);
    }
    static function listUser_api(Request $request){

        $access_token = self::getAccessToken()->data->access_token->access_token;
        $client = new Client;
        $URI = config('global.base_api').'/recommender/user?page='.$request->page;
        $params['headers'] = ['Accept' => 'application/json' , 'Content-Type' => 'application/x-www-form-urlencoded' , 'Authorization' => 'Bearer '.$access_token];
        try{
            $res = $client->get( $URI, $params );
            $response =  $res->getBody()->getContents();
        }catch (RequestException $e) {
            if ($e->hasResponse()) {
                $response = json_encode(['error' => $e->getResponse()->getReasonPhrase() , 'code' => $e->getCode() , 'body' => null]);
            }else
                $response =json_encode(['error' => $e->getMessage() , 'code' => $e->getCode() , 'body' => null]);
        }
        return json_decode('['.$response.']');
    }
    static function todayUser(Request $request){

        $access_token = self::getAccessToken()->data->access_token->access_token;
        $client = new Client;
        $URI = config('global.base_api').'/recommender/user/today?page='.$request->page;
        $params['headers'] = ['Accept' => 'application/json' , 'Content-Type' => 'application/x-www-form-urlencoded' , 'Authorization' => 'Bearer '.$access_token];
        try{
            $res = $client->get( $URI, $params );
            $response =  $res->getBody()->getContents();
        }catch (RequestException $e) {
            if ($e->hasResponse()) {
                $response = json_encode(['error' => $e->getResponse()->getReasonPhrase() , 'code' => $e->getCode() , 'body' => null]);
            }else
                $response =json_encode(['error' => $e->getMessage() , 'code' => $e->getCode() , 'body' => null]);
        }
        return json_decode('['.$response.']');
    }

    static function userInformation($id){
        $access_token = self::getAccessToken()->data->access_token->access_token;

        $URI = config('global.base_api').'/user/'.$id.'?parameters=["mobile_number","gender","name","lastname","birthday","national_code","email"]';

        $client = new Client;
        $params['headers'] = ['Accept' => 'application/json' , 'Content-Type' => 'application/x-www-form-urlencoded' , 'Authorization' => 'Bearer '.$access_token];
        $params['form_params'] = array();
        try
        {
            $res = $client->get( $URI, $params );
            $response =  $res->getBody()->getContents();
        }catch (RequestException $e) {
            if ($e->hasResponse()) {
                $response = json_encode(['error' => $e->getResponse()->getReasonPhrase() , 'code' => $e->getCode() , 'body' => null]);
            }else
                $response =json_encode(['error' => $e->getMessage() , 'code' => $e->getCode() , 'body' => null]);
        }

        return json_decode($response);
    }
    static function invoiceInformation($id){
        $access_token = self::getAccessToken()->data->access_token->access_token;

        $URI = config('global.base_api').'/order/'.$id;


        $client = new Client;
        $params['headers'] = ['Accept' => 'application/json' , 'Content-Type' => 'application/x-www-form-urlencoded' , 'Authorization' => 'Bearer '.$access_token];
        $params['form_params'] = array();
        try
        {
            $res = $client->get( $URI, $params );
            $response =  $res->getBody()->getContents();
        }catch (RequestException $e) {
            if ($e->hasResponse()) {
                $response = json_encode(['error' => $e->getResponse()->getReasonPhrase() , 'code' => $e->getCode() , 'body' => null]);
            }else
                $response =json_encode(['error' => $e->getMessage() , 'code' => $e->getCode() , 'body' => null]);
        }
        return json_decode($response);
    }

    static function listWebsites($mobile_number,$queryString,Request $request){
        $access_token = self::getAccessToken()->data->access_token->access_token;
        $client = new Client;
        if (is_null($queryString))
            $queryString="mobile_number=".$mobile_number;
        else
            $queryString=$queryString."&mobile_number=".$mobile_number;
        $URI = config('global.base_api').'/license?'.$queryString;
        $params['headers'] = ['Accept' => 'application/json' , 'Content-Type' => 'application/x-www-form-urlencoded' , 'Authorization' => 'Bearer '.$access_token];

        try{
            $res = $client->get( $URI, $params );

            $response =  $res->getBody()->getContents();
        }catch (RequestException $e) {
            if ($e->hasResponse()) {

                $response = json_encode(['error' => $e->getResponse()->getReasonPhrase() , 'code' => $e->getCode() , 'body' => null]);
            }else
                $response =json_encode(['error' => $e->getMessage() , 'code' => $e->getCode() , 'body' => null]);
        }
        return self::paginate(json_decode($response), $request);
    }

    static function listInvoices($mobile_number,$queryString,Request $request){
        if (is_null($queryString))
            $queryString="mobile_number=".$mobile_number;
        else
            $queryString=$queryString."&mobile_number=".$mobile_number;

        $access_token = self::getAccessToken()->data->access_token->access_token;
        $client = new Client;
        $URI = config('global.base_api').'/order?'.$queryString;
        $params['headers'] = ['Accept' => 'application/json' , 'Content-Type' => 'application/x-www-form-urlencoded' , 'Authorization' => 'Bearer '.$access_token];
        try{
            $res = $client->get( $URI, $params );
            $response =  $res->getBody()->getContents();
        }catch (RequestException $e) {
            if ($e->hasResponse()) {
                $response = json_encode(['error' => $e->getResponse()->getReasonPhrase() , 'code' => $e->getCode() , 'body' => null]);
            }else
                $response =json_encode(['error' => $e->getMessage() , 'code' => $e->getCode() , 'body' => null]);
        }

        return self::paginate(json_decode($response), $request);
    }


    static function paginate($model,$request)
    {
        $base_url = self::removeqsvar($request->fullUrl() , 'page');
        return self::paginator($model->data, $model->meta->total, $model->meta->per_page, $model->meta->current_page, [
            'path' =>$base_url,
            'pageName' => "page",
        ]);
    }

    static protected function paginator($items, $total, $perPage, $currentPage, $options)
    {
        return Container::getInstance()->makeWith(LengthAwarePaginator::class, compact(
            'items', 'total', 'perPage', 'currentPage', 'options'
        ));
    }

    static function removeqsvar($url, $varname) {
        list($urlpart, $qspart) = array_pad(explode('?', $url), 2, '');
        parse_str($qspart, $qsvars);
        unset($qsvars[$varname]);
        $newqs = http_build_query($qsvars);
        return $urlpart . '?' . $newqs;
    }

    static function get_id_user_by_mobile($body){
        $access_token = self::getAccessToken()->data->access_token->access_token;
        $client = new Client;
        $URI = config('global.base_api').'/user/numbers';
        $res = $client->get( $URI ,
            [
                'headers' => [
                    'Accept' => "application/json",
                    'Content-Type' => "application/json",
                    'Authorization' => 'Bearer '.$access_token
                ],
                'body' => $body
            ]
        );
        $response =  $res->getBody()->getContents();

        return json_decode($response);
    }

    static function save_document($title , $file , $user_id){
        $access_token = self::getAccessToken()->data->access_token->access_token;
        $client = new Client;
        $URI = config('global.base_api').'/user/file';
        $params['headers'] = ['Accept' => 'application/json' , 'Content-Type' => 'application/x-www-form-urlencoded' , 'Authorization' => 'Bearer '.$access_token];
        $params['form_params'] = array('title' => $title , 'file' => $file , 'user_id' => $user_id);
        try{
            $res = $client->post( $URI, $params );
            $response =  json_encode(['error' => null , 'code' => $res->getStatusCode() , 'body' => json_decode($res->getBody()->getContents())]);
        }catch (RequestException $e) {
            if ($e->hasResponse()) {
                $response = json_encode(['error' => $e->getResponse()->getReasonPhrase() , 'code' => $e->getCode() , 'body' => null]);
            }else{
                $response =json_encode(['error' => $e->getMessage() , 'code' => $e->getCode() , 'body' => null]);
            }
        }
        return json_decode($response);
    }

    static function delete_document($file_id , $user_id){
        $access_token = self::getAccessToken()->data->access_token->access_token;
        $client = new Client;
        $URI = config('global.base_api').'/user/file/delete';
        $params['headers'] = ['Accept' => 'application/json' , 'Content-Type' => 'application/x-www-form-urlencoded' , 'Authorization' => 'Bearer '.$access_token];
        $params['form_params'] = array('file_id' => $file_id , 'user_id' => $user_id);
        try{
            $res = $client->post( $URI, $params );
            $response =  json_encode(['error' => null , 'code' => $res->getStatusCode() , 'body' => json_decode($res->getBody()->getContents())]);
        }catch (RequestException $e) {
            if ($e->hasResponse()) {
                $response = json_encode(['error' => $e->getResponse()->getReasonPhrase() , 'code' => $e->getCode() , 'body' => null]);
            }else{
                $response =json_encode(['error' => $e->getMessage() , 'code' => $e->getCode() , 'body' => null]);
            }
        }
        return json_decode($response);
    }

    static function get_document($user_id){
        $access_token = self::getAccessToken()->data->access_token->access_token;
        $client = new Client;
        $URI = config('global.base_api').'/user/file/'.$user_id;
        $params['headers'] = ['Accept' => 'application/json' , 'Content-Type' => 'application/x-www-form-urlencoded' , 'Authorization' => 'Bearer '.$access_token];
        $params['form_params'] = array();
        try{
            $res = $client->get( $URI, $params );
            $response =  json_encode(['error' => null , 'code' => $res->getStatusCode() , 'body' => json_decode($res->getBody()->getContents())]);
        }catch (RequestException $e) {
            if ($e->hasResponse()) {
                $response = json_encode(['error' => $e->getResponse()->getReasonPhrase() , 'code' => $e->getCode() , 'body' => null]);
            }else{
                $response =json_encode(['error' => $e->getMessage() , 'code' => $e->getCode() , 'body' => null]);
            }
        }
        return json_decode($response);
    }
}
