<?php
/**
 * Created by PhpStorm.
 * User: ladan
 * Date: 12/10/2018
 * Time: 9:28
 */

namespace App\Traits;


use GuzzleHttp\Client;
use GuzzleHttp\Exception\RequestException;

trait Live
{
    static function create($name , $meetingID , $duration , $welcome ,  $logo , $maxParticipants , $bannerText , $copyright , $logout , $message_status , $webcam_status)
    {
        $secretKey = config('global.secret_key_live');
        $ch = 'create' . 'name='.urlencode($name) . '&meetingID='.$meetingID . '&duration='.$duration . '&maxParticipants='.$maxParticipants . '&bannerText='.urlencode($bannerText) . '&copyright='.urlencode($copyright) . '&welcome='.urlencode($welcome) . '&logo='.$logo . '&logoutURL='.$logout . '&webcamsOnlyForModerator='.$webcam_status . '&moderatorOnlyMessage='.$message_status . $secretKey;
        $checksum  = sha1($ch);

        $query = 'name='.urlencode($name) . '&meetingID='.$meetingID . '&duration='.$duration . '&maxParticipants='.$maxParticipants . '&bannerText='.urlencode($bannerText) . '&copyright='.urlencode($copyright) . '&welcome='.urlencode($welcome) . '&logo='.$logo . '&logoutURL='.$logout . '&webcamsOnlyForModerator='.$webcam_status . '&moderatorOnlyMessage='.$message_status . '&checksum='.$checksum;


        $api_url    = config('global.live_api').'/create?'.$query;
        $body = '<modules>
                   <module name="presentation">
                      <document url="http://yekitaapp.com/cdn/yekita.pdf" filename="report.pdf"/>
                   </module>
                </modules>';

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $api_url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/xml'
        ));
        curl_setopt($ch, CURLOPT_POSTFIELDS, $body);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $response = curl_exec($ch);
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        return $response;
    }

    static function isMeetingRunning($meetingID){
        $secretKey = config('global.secret_key_live');
        $checksum  = sha1('isMeetingRunning' . 'meetingID='. $meetingID . $secretKey);
        $client = new Client();
        $URI = config('global.live_api').'/isMeetingRunning';
        $params['query'] = array('meetingID' => $meetingID, 'checksum' => $checksum);
        try
        {
            $res = $client->post($URI, $params );
            $response =  ['error' => null , 'code' => $res->getStatusCode() , 'body' => $res->getBody()->getContents()];
        }catch (RequestException $e) {
            if ($e->hasResponse()) {
                $response = json_encode(['error' => $e->getResponse()->getReasonPhrase() , 'code' => $e->getCode() , 'body' => null]);
            }else{
                $response =json_encode(['error' => $e->getMessage() , 'code' => $e->getCode() , 'body' => null]);
            }
        }
        return $response;
    }

    static function getMeetingInfo($meetingID , $password){
        $secretKey = config('global.secret_key_live');
        $checksum  = sha1('getMeetingInfo' . 'meetingID=' . $meetingID . '&password=' . $password . $secretKey);
        $client = new Client();
        $URI = config('global.live_api').'/getMeetingInfo';
        $params['query'] = array('meetingID' => $meetingID, 'password' => $password, 'checksum' => $checksum);
        try
        {
            $res = $client->post($URI, $params );
            $response =  ['error' => null , 'code' => $res->getStatusCode() , 'body' => $res->getBody()->getContents()];
        }catch (RequestException $e) {
            if ($e->hasResponse()) {
                $response = json_encode(['error' => $e->getResponse()->getReasonPhrase() , 'code' => $e->getCode() , 'body' => null]);
            }else{
                $response =json_encode(['error' => $e->getMessage() , 'code' => $e->getCode() , 'body' => null]);
            }
        }
        return $response;
    }
}